/*
 * Decompiled with CFR 0.152.
 */
package ncsa.devices.virtual;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Panel;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3f;
import ncsa.devices.AdjustableInterface;
import ncsa.devices.AdjustmentInterface;
import ncsa.devices.AdjustmentValues;
import ncsa.devices.NCSAInputDevice;
import ncsa.devices.ValuesWithRotation;
import ncsa.devices.virtual.ButtonButtonControls;
import ncsa.devices.virtual.ButtonPositionControls;
import ncsa.devices.virtual.ButtonRotationControls;
import ncsa.devices.virtual.PositionControls;

public class VirtualInputDevice
extends NCSAInputDevice
implements AdjustableInterface,
ValuesWithRotation {
    private PositionControls positionControls;
    private ButtonRotationControls rotationControls;
    private ButtonButtonControls buttonControls;
    float[] data = new float[6];
    Vector3f vector = new Vector3f();
    float xrot;
    float yrot;
    float zrot;
    Transform3D working = new Transform3D();
    Transform3D temp = new Transform3D();
    AdjustmentValues adjust;
    float _x;
    float _y;
    float _z;
    float _xr;
    float _yr;
    float _zr;

    public VirtualInputDevice() {
        this("VirtualInputDevice", 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public VirtualInputDevice(String string, float f, float f2, float f3, float f4, float f5, float f6) {
        this._x = f;
        this._y = f2;
        this._z = f3;
        this._xr = f4;
        this._yr = f5;
        this._zr = f6;
    }

    public AdjustmentInterface getAdjustmentInterface() {
        return this.adjust;
    }

    public float getX(int n) {
        return this.vector.x;
    }

    public float getXR(int n) {
        return this.xrot;
    }

    public float getY(int n) {
        return this.vector.y;
    }

    public float getYR(int n) {
        return this.yrot;
    }

    public float getZ(int n) {
        return this.vector.z;
    }

    public float getZR(int n) {
        return this.zrot;
    }

    public void pollAndProcessInput() {
        this.rotationControls.update();
        this.positionControls.getPosition(this.vector);
        this.vector.x *= this.adjust.getPositionScale();
        this.vector.x = this.adjust.getInversion(0, 0) ? -this.vector.x : this.vector.x;
        this.vector.x += this.adjust.getOffset(0, 0);
        this.vector.y *= this.adjust.getPositionScale();
        this.vector.y = this.adjust.getInversion(0, 1) ? -this.vector.y : this.vector.y;
        this.vector.y += this.adjust.getOffset(0, 1);
        this.vector.z *= this.adjust.getPositionScale();
        this.vector.z = this.adjust.getInversion(0, 2) ? -this.vector.z : this.vector.z;
        this.vector.z += this.adjust.getOffset(0, 2);
        this.temp.set(this.vector);
        this.xrot = this.rotationControls.getXAngle();
        this.xrot = this.adjust.getInversion(0, 3) ? -this.xrot : this.xrot;
        this.xrot = this.xrot * this.adjust.getRotationScale() + this.adjust.getOffset(0, 3);
        this.working.rotX((double)this.xrot);
        this.temp.mul(this.working);
        this.yrot = this.rotationControls.getYAngle();
        this.yrot = this.adjust.getInversion(0, 4) ? -this.yrot : this.yrot;
        this.yrot = this.yrot * this.adjust.getRotationScale() + this.adjust.getOffset(0, 4);
        this.working.rotY((double)this.yrot);
        this.temp.mul(this.working);
        this.zrot = this.rotationControls.getZAngle();
        this.zrot = this.adjust.getInversion(0, 5) ? -this.zrot : this.zrot;
        this.zrot = this.zrot * this.adjust.getRotationScale() + this.adjust.getOffset(0, 5);
        this.working.rotZ((double)this.zrot);
        this.temp.mul(this.working);
        this.sensorReads[0].setTime(System.currentTimeMillis());
        this.sensorReads[0].set(this.temp);
        this.sensors[0].setNextSensorRead(this.sensorReads[0]);
    }

    public void portfolioDeviceInitializing() {
        Frame frame = new Frame();
        frame.setTitle(this.name);
        ButtonPositionControls buttonPositionControls = new ButtonPositionControls(this._x, this._y, this._z);
        this.rotationControls = new ButtonRotationControls(this._xr, this._yr, this._zr);
        buttonPositionControls.setDevice(this);
        this.buttonControls = new ButtonButtonControls(this.buttons[0].length, this.sensorReads[0]);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("East", buttonPositionControls);
        panel.add("West", this.rotationControls);
        panel.add("North", this.buttonControls);
        frame.add(panel);
        frame.pack();
        ((Component)frame).setVisible(true);
        this.adjust = new AdjustmentValues(this.name, this.getSensorCount());
        this.positionControls = buttonPositionControls;
    }
}

