/*
 * Decompiled with CFR 0.152.
 */
package ncsa.devices.virtual;

import java.awt.Button;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.media.j3d.InputDevice;
import ncsa.devices.virtual.RotationControls;

public class ButtonRotationControls
extends Panel
implements RotationControls,
MouseListener {
    private static final int STILL = 0;
    private static final int ROTXP = 1;
    private static final int ROTXM = 2;
    private static final int ROTYP = 3;
    private static final int ROTYM = 4;
    private static final int ROTZP = 5;
    private static final int ROTZM = 6;
    private int mode = 0;
    protected float x;
    protected float y;
    protected float z;
    protected float tx;
    protected float ty;
    protected float tz;
    private Button XP = new Button("X+");
    private Button XM = new Button("X-");
    private Button YP = new Button("Y+");
    private Button YM = new Button("Y-");
    private Button ZP = new Button("Z+");
    private Button ZM = new Button("Z-");
    private InputDevice device;
    private float step_rate = 0.001f;
    private long time_last_state_change = System.currentTimeMillis();

    public ButtonRotationControls(float f, float f2, float f3) {
        this.setLayout(new GridLayout(3, 2));
        this.add(this.XP);
        this.add(this.XM);
        this.add(this.YP);
        this.add(this.YM);
        this.add(this.ZP);
        this.add(this.ZM);
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.XP.addMouseListener(this);
        this.XM.addMouseListener(this);
        this.YP.addMouseListener(this);
        this.YM.addMouseListener(this);
        this.ZP.addMouseListener(this);
        this.ZM.addMouseListener(this);
    }

    public float getXAngle() {
        return this.x;
    }

    public float getYAngle() {
        return this.y;
    }

    public float getZAngle() {
        return this.z;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.XP && this.mode != 1) {
            this.time_last_state_change = System.currentTimeMillis();
            this.mode = 1;
            this.tx = this.x;
        } else if (mouseEvent.getSource() == this.XM && this.mode != 2) {
            this.time_last_state_change = System.currentTimeMillis();
            this.mode = 2;
            this.tx = this.x;
        } else if (mouseEvent.getSource() == this.YP && this.mode != 3) {
            this.time_last_state_change = System.currentTimeMillis();
            this.mode = 3;
            this.ty = this.y;
        } else if (mouseEvent.getSource() == this.YM && this.mode != 4) {
            this.time_last_state_change = System.currentTimeMillis();
            this.mode = 4;
            this.ty = this.y;
        } else if (mouseEvent.getSource() == this.ZP && this.mode != 5) {
            this.time_last_state_change = System.currentTimeMillis();
            this.mode = 5;
            this.tz = this.z;
        } else if (mouseEvent.getSource() == this.ZM && this.mode != 6) {
            this.time_last_state_change = System.currentTimeMillis();
            this.mode = 6;
            this.tz = this.z;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mode = 0;
    }

    public void reset() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public void setDevice(InputDevice inputDevice) {
        this.device = inputDevice;
    }

    public void setStepRate(float f) {
        this.step_rate = f;
    }

    public void update() {
        long l = System.currentTimeMillis();
        long l2 = l - this.time_last_state_change;
        switch (this.mode) {
            case 2: {
                this.x = this.tx - this.step_rate * (float)l2;
                break;
            }
            case 1: {
                this.x = this.tx + this.step_rate * (float)l2;
                break;
            }
            case 3: {
                this.y = this.ty + this.step_rate * (float)l2;
                break;
            }
            case 4: {
                this.y = this.ty - this.step_rate * (float)l2;
                break;
            }
            case 6: {
                this.z = this.tz - this.step_rate * (float)l2;
                break;
            }
            case 5: {
                this.z = this.tz + this.step_rate * (float)l2;
                break;
            }
            default: {
                throw new RuntimeException("Unknown motion");
            }
            case 0: 
        }
    }
}

