/*
 * Decompiled with CFR 0.152.
 */
package ncsa.devices.virtual;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.media.j3d.InputDevice;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import ncsa.devices.virtual.PositionControls;

public class ButtonPositionControls
extends Panel
implements PositionControls,
MouseListener {
    private static final int STILL = 0;
    private static final int MOVING_UP = 1;
    private static final int MOVING_DOWN = 2;
    private static final int MOVING_LEFT = 3;
    private static final int MOVING_RIGHT = 4;
    private static final int MOVING_FORWARD = 5;
    private static final int MOVING_BACK = 6;
    private int mode = 0;
    Vector3f position = new Vector3f();
    Vector3f orig_position = new Vector3f();
    private Button leftB = new Button("Move Left");
    private Button rightB = new Button("Move Right");
    private Button upB = new Button("Move Up");
    private Button downB = new Button("Move Down");
    private Button forwardB = new Button("Move Forward");
    private Button backwardB = new Button("Move Back");
    private Button reset = new Button("Reset");
    private InputDevice device;
    private float step_rate = 0.0023f;
    private long time_last_state_change = System.currentTimeMillis();

    public ButtonPositionControls(float f, float f2, float f3) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("North", this.upB);
        panel.add("East", this.rightB);
        panel.add("South", this.downB);
        panel.add("West", this.leftB);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(0, 1, 0, 0));
        panel2.add(this.forwardB);
        panel2.add(this.backwardB);
        panel2.add(this.reset);
        this.position.x = f;
        this.position.y = f2;
        this.position.z = f3;
        this.orig_position.set((Tuple3f)this.position);
        this.upB.addMouseListener(this);
        this.downB.addMouseListener(this);
        this.leftB.addMouseListener(this);
        this.rightB.addMouseListener(this);
        this.forwardB.addMouseListener(this);
        this.backwardB.addMouseListener(this);
        this.reset.addMouseListener(this);
        this.setLayout(new BorderLayout());
        this.add("East", panel2);
        this.add("West", panel);
    }

    private void calculateMotion() {
        long l = System.currentTimeMillis();
        long l2 = l - this.time_last_state_change;
        switch (this.mode) {
            case 3: {
                this.position.x = this.orig_position.x - this.step_rate * (float)l2;
                break;
            }
            case 4: {
                this.position.x = this.orig_position.x + this.step_rate * (float)l2;
                break;
            }
            case 1: {
                this.position.y = this.orig_position.y + this.step_rate * (float)l2;
                break;
            }
            case 2: {
                this.position.y = this.orig_position.y - this.step_rate * (float)l2;
                break;
            }
            case 5: {
                this.position.z = this.orig_position.z - this.step_rate * (float)l2;
                break;
            }
            case 6: {
                this.position.z = this.orig_position.z + this.step_rate * (float)l2;
                break;
            }
            default: {
                throw new RuntimeException("Unknown motion");
            }
            case 0: 
        }
    }

    public void getPosition(Vector3f vector3f) {
        this.calculateMotion();
        vector3f.set((Tuple3f)this.position);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.leftB && this.mode != 3) {
            this.time_last_state_change = System.currentTimeMillis();
            this.mode = 3;
            this.orig_position.set((Tuple3f)this.position);
        } else if (mouseEvent.getSource() == this.rightB && this.mode != 4) {
            this.time_last_state_change = System.currentTimeMillis();
            this.mode = 4;
            this.orig_position.set((Tuple3f)this.position);
        } else if (mouseEvent.getSource() == this.upB && this.mode != 1) {
            this.time_last_state_change = System.currentTimeMillis();
            this.mode = 1;
            this.orig_position.set((Tuple3f)this.position);
        } else if (mouseEvent.getSource() == this.downB && this.mode != 2) {
            this.time_last_state_change = System.currentTimeMillis();
            this.mode = 2;
            this.orig_position.set((Tuple3f)this.position);
        } else if (mouseEvent.getSource() == this.forwardB && this.mode != 5) {
            this.time_last_state_change = System.currentTimeMillis();
            this.mode = 5;
            this.orig_position.set((Tuple3f)this.position);
        } else if (mouseEvent.getSource() == this.backwardB && this.mode != 6) {
            this.time_last_state_change = System.currentTimeMillis();
            this.mode = 6;
            this.orig_position.set((Tuple3f)this.position);
        } else if (mouseEvent.getSource() == this.reset) {
            this.device.setNominalPositionAndOrientation();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mode = 0;
    }

    public void setDevice(InputDevice inputDevice) {
        this.device = inputDevice;
    }

    public void setPosition(Vector3f vector3f) {
        this.position.set((Tuple3f)vector3f);
    }

    public void setStepRate(float f) {
        this.step_rate = f;
    }
}

