/*
 * Decompiled with CFR 0.152.
 */
package ncsa.devices.spaceorb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;
import ncsa.devices.spaceorb.OrbData;

public class SpaceOrbDriver
implements SerialPortEventListener {
    SerialPort serialPort = null;
    InputStream inputStream = null;
    OutputStream outputStream = null;
    public OrbData handle = new OrbData();
    byte[] buffer = new byte[1024];
    byte[] xorme = new byte[20];

    public SpaceOrbDriver(String string) {
        CommPortIdentifier commPortIdentifier = this.getPortId(string);
        this.setup(commPortIdentifier);
        this.setXorme();
    }

    public void addEventListener(SerialPortEventListener serialPortEventListener) {
        try {
            this.serialPort.notifyOnDataAvailable(true);
            this.serialPort.addEventListener(serialPortEventListener);
        }
        catch (TooManyListenersException tooManyListenersException) {
            System.out.println("SpaceOrbDriver.addEventListener");
            System.out.println(tooManyListenersException);
        }
    }

    public void begin() {
        this.start();
        this.rezero();
    }

    protected final void figurePackType(int n) {
        switch (this.buffer[n]) {
            case 17: {
                this.handle.bufpos = 0;
                this.handle.packtype = 0;
                this.handle.packlen = 1;
                break;
            }
            case 33: {
                this.handle.bufpos = 0;
                this.handle.packtype = 82;
                this.handle.packlen = 83;
                break;
            }
            case 68: {
                this.handle.packtype = 68;
                this.handle.packlen = 12;
                break;
            }
            case 75: {
                this.handle.packtype = 75;
                this.handle.packlen = 5;
                break;
            }
            case 78: {
                this.handle.packtype = 78;
                this.handle.packlen = 3;
                break;
            }
            case 80: {
                this.handle.packtype = 80;
                this.handle.packlen = 4;
                break;
            }
            case 82: {
                this.handle.packtype = 82;
                this.handle.packlen = 51;
                break;
            }
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    protected CommPortIdentifier getPortId(String string) {
        if (string == null) {
            return null;
        }
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        while (enumeration.hasMoreElements()) {
            CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            if (commPortIdentifier.getPortType() != 1 || !commPortIdentifier.getName().equals(string)) continue;
            return commPortIdentifier;
        }
        System.out.println("SpaceOrbDriver: could not find port " + string);
        return null;
    }

    protected final void handlePackType() {
        switch (this.handle.packtype) {
            case 68: {
                int n = (this.handle.buf[2] & 0x7F) << 3 | (this.handle.buf[3] & 0x70) >> 4;
                int n2 = (this.handle.buf[3] & 0xF) << 6 | (this.handle.buf[4] & 0x7E) >> 1;
                int n3 = (this.handle.buf[4] & 1) << 9 | (this.handle.buf[5] & 0x7F) << 2 | (this.handle.buf[6] & 0x60) >> 5;
                int n4 = (this.handle.buf[6] & 0x1F) << 5 | (this.handle.buf[7] & 0x7C) >> 2;
                int n5 = (this.handle.buf[7] & 3) << 8 | (this.handle.buf[8] & 0x7F) << 1 | (this.handle.buf[9] & 0x40) >> 6;
                int n6 = (this.handle.buf[9] & 0x3F) << 4 | (this.handle.buf[10] & 0x78) >> 3;
                this.handle.timer = (this.handle.buf[10] & 7) << 7 | this.handle.buf[11] & 0x7F;
                this.handle.trans[0] = n << 22 >> 22;
                this.handle.trans[1] = n2 << 22 >> 22;
                this.handle.trans[2] = n3 << 22 >> 22;
                this.handle.rot[0] = n4 << 22 >> 22;
                this.handle.rot[1] = n5 << 22 >> 22;
                this.handle.rot[2] = n6 << 22 >> 22;
                break;
            }
            case 75: {
                this.handle.buttons = this.handle.buf[2] & 0x7F;
                this.handle.timer = (this.handle.buf[1] & 0x7F) << 8 | this.handle.buf[4] & 0x7F;
                break;
            }
            case 82: {
                int n = 0;
                while (n < this.handle.resetstring.length) {
                    this.handle.resetstring[n] = 0;
                    ++n;
                }
                n = 0;
                while (n < this.handle.bufpos) {
                    this.handle.resetstring[n] = (byte)(this.handle.buf[n] & 0x7F);
                    ++n;
                }
                break;
            }
        }
    }

    public static void main(String[] stringArray) {
        SpaceOrbDriver spaceOrbDriver = new SpaceOrbDriver(stringArray[0]);
        spaceOrbDriver.addEventListener(spaceOrbDriver);
        spaceOrbDriver.begin();
        while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            System.out.println(String.valueOf(spaceOrbDriver.handle.trans[0]) + " " + spaceOrbDriver.handle.trans[1] + " " + spaceOrbDriver.handle.trans[2] + " " + spaceOrbDriver.handle.rot[0] + " " + spaceOrbDriver.handle.rot[1] + " " + spaceOrbDriver.handle.rot[2]);
        }
    }

    protected void rezero() {
        byte[] byArray = new byte[]{10, 90, 10, 0};
        this.write(byArray);
    }

    public final void serialEvent(SerialPortEvent serialPortEvent) {
        switch (serialPortEvent.getEventType()) {
            case 1: {
                try {
                    while (this.inputStream.available() > 0) {
                        this.update();
                    }
                }
                catch (IOException iOException) {
                    System.out.println("WandDriver.serialEvent");
                    System.out.println(iOException);
                }
                break;
            }
        }
    }

    protected void setXorme() {
        this.xorme[0] = 68;
        this.xorme[1] = 46;
        this.xorme[2] = 83;
        this.xorme[3] = 112;
        this.xorme[4] = 97;
        this.xorme[5] = 99;
        this.xorme[6] = 101;
        this.xorme[7] = 87;
        this.xorme[8] = 97;
        this.xorme[9] = 114;
        this.xorme[10] = 101;
        this.xorme[11] = 33;
        this.xorme[12] = 32;
        this.xorme[13] = 32;
        this.xorme[14] = 32;
        this.xorme[15] = 32;
        this.xorme[16] = 32;
        this.xorme[17] = 32;
        this.xorme[18] = 32;
        this.xorme[19] = 32;
    }

    protected void setup(CommPortIdentifier commPortIdentifier) {
        try {
            this.serialPort = (SerialPort)commPortIdentifier.open("SpaceOrbDriver", 2000);
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
            this.serialPort.setSerialPortParams(9600, 8, 1, 0);
        }
        catch (IOException iOException) {
            System.out.println("SpaceOrbDriver.setup(CommPortIdentifier)");
            System.out.println(iOException);
        }
        catch (PortInUseException portInUseException) {
            System.out.println("SpaceOrbDriver.setup PORT IN USE");
            System.out.println((Object)portInUseException);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            System.out.println("SpaceOrbDriver.setup");
            System.out.println((Object)unsupportedCommOperationException);
        }
    }

    protected void start() {
        byte[] byArray = new byte[]{10, 0};
        this.write(byArray);
    }

    protected void update() {
        int n;
        int n2 = 0;
        try {
            n = this.inputStream.read(this.buffer);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            n = 0;
        }
        if (n < 1) {
            return;
        }
        int n3 = 0;
        while (n3 < n) {
            if (this.buffer[n3] == 13 && this.handle.packtype != 82) {
                this.handle.bufpos = 0;
                this.handle.packtype = 0;
                this.handle.packlen = 1;
            } else {
                if (this.handle.bufpos == 0) {
                    this.figurePackType(n3);
                }
                if (this.handle.packtype == 68) {
                    this.handle.buf[this.handle.bufpos] = (byte)(this.buffer[n3] ^ this.xorme[this.handle.bufpos]);
                    ++this.handle.bufpos;
                } else {
                    this.handle.buf[this.handle.bufpos++] = this.buffer[n3];
                }
                if (this.handle.bufpos == this.handle.packlen) {
                    this.handlePackType();
                    this.handle.bufpos = 0;
                    this.handle.packtype = 0;
                    this.handle.packlen = 1;
                    ++n2;
                }
            }
            ++n3;
        }
    }

    protected void write(byte[] byArray) {
        try {
            this.outputStream.write(byArray);
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            Thread.dumpStack();
        }
    }
}

