/*
 * Decompiled with CFR 0.152.
 */
package ncsa.devices.spaceorb;

import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3d;
import ncsa.devices.AdjustmentValues;
import ncsa.devices.NCSAInputDevice;
import ncsa.devices.spaceorb.SpaceOrbDriver;
import ncsa.j3d.ui.PortfolioProperties;

public class SpaceOrbDevice
extends NCSAInputDevice {
    Transform3D transform = new Transform3D();
    Transform3D working = new Transform3D();
    Vector3d vector = new Vector3d();
    AdjustmentValues adjust;
    int[] buts = new int[6];
    SpaceOrbDriver driver;
    String portName;

    protected void parseProperties() {
        PortfolioProperties portfolioProperties = PortfolioProperties.instance();
        this.portName = portfolioProperties.getProperty(String.valueOf(this.name) + ".Port");
        System.out.println("SpaceOrb on port " + this.portName);
    }

    public final void pollAndProcessInput() {
        this.transform.setIdentity();
        this.vector.x = (double)((float)this.driver.handle.rot[0] / 512.0f) * Math.PI;
        this.vector.y = (double)((float)this.driver.handle.rot[1] / 512.0f) * Math.PI;
        this.vector.z = (double)((float)this.driver.handle.rot[2] / 512.0f) * Math.PI;
        this.working.rotX(this.vector.x);
        this.transform.mul(this.working);
        this.working.rotY(this.vector.y);
        this.transform.mul(this.working);
        this.working.rotZ(this.vector.z);
        this.transform.mul(this.working);
        this.vector.x = (float)this.driver.handle.trans[0] / 22.0f;
        this.vector.y = (float)this.driver.handle.trans[1] / 22.0f;
        this.vector.z = (float)this.driver.handle.trans[2] / 22.0f;
        this.transform.setTranslation(this.vector);
        this.buts[0] = (this.driver.handle.buttons & 1) != 0 ? 1 : 0;
        this.buts[1] = (this.driver.handle.buttons & 2) != 0 ? 1 : 0;
        this.buts[2] = (this.driver.handle.buttons & 4) != 0 ? 1 : 0;
        this.buts[3] = (this.driver.handle.buttons & 8) != 0 ? 1 : 0;
        this.buts[4] = (this.driver.handle.buttons & 0x10) != 0 ? 1 : 0;
        this.buts[5] = (this.driver.handle.buttons & 0x20) != 0 ? 1 : 0;
        this.sensorReads[0].setButtons(this.buts);
        this.sensorReads[0].setTime(System.currentTimeMillis());
        this.sensorReads[0].set(this.transform);
        this.sensors[0].setNextSensorRead(this.sensorReads[0]);
    }

    public void portfolioDeviceInitializing() {
        this.buildSensorWithButtons(0, 6);
        this.parseProperties();
        this.adjust = new AdjustmentValues(this.name, this.getSensorCount());
        this.driver = new SpaceOrbDriver(this.portName);
        this.driver.addEventListener(this.driver);
        this.driver.begin();
    }
}

