/*
 * Decompiled with CFR 0.152.
 */
package ncsa.devices.spaceorb;

import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.media.j3d.SensorRead;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3d;
import ncsa.devices.spaceorb.SpaceOrbDriver;

public class SpaceOrb
implements InputDevice {
    private int processingMode = 5;
    Transform3D transform = new Transform3D();
    Transform3D working = new Transform3D();
    Vector3d vector = new Vector3d();
    static int BUTTONS = 6;
    int[] buts = new int[BUTTONS];
    Sensor sensor = new Sensor((InputDevice)this, 20, BUTTONS);
    SensorRead sensorRead = new SensorRead(BUTTONS);
    SpaceOrbDriver driver;
    float rotationScale = 1.0f;
    float positionScale = 512.0f;

    public SpaceOrb() {
        this("/dev/term/a");
    }

    public SpaceOrb(String string) {
        this.driver = new SpaceOrbDriver(string);
        this.driver.addEventListener(this.driver);
        this.driver.begin();
    }

    public void close() {
    }

    public int getProcessingMode() {
        return this.processingMode;
    }

    public Sensor getSensor(int n) {
        if (n != 0) {
            return null;
        }
        return this.sensor;
    }

    public int getSensorCount() {
        return 1;
    }

    public boolean initialize() {
        return true;
    }

    public final void pollAndProcessInput() {
        this.transform.setIdentity();
        float f = (float)(Math.PI / (double)this.rotationScale);
        this.vector.x = (float)this.driver.handle.rot[0] / 512.0f * f;
        this.vector.y = (float)this.driver.handle.rot[1] / 512.0f * f;
        this.vector.z = (float)this.driver.handle.rot[2] / 512.0f * f;
        this.working.rotX(this.vector.x);
        this.transform.mul(this.working);
        this.working.rotY(this.vector.y);
        this.transform.mul(this.working);
        this.working.rotZ(this.vector.z);
        this.transform.mul(this.working);
        this.vector.x = (float)this.driver.handle.trans[0] / this.positionScale;
        this.vector.y = (float)this.driver.handle.trans[1] / this.positionScale;
        this.vector.z = (float)this.driver.handle.trans[2] / this.positionScale;
        this.transform.setTranslation(this.vector);
        this.buts[0] = (this.driver.handle.buttons & 1) != 0 ? 1 : 0;
        this.buts[1] = (this.driver.handle.buttons & 2) != 0 ? 1 : 0;
        this.buts[2] = (this.driver.handle.buttons & 4) != 0 ? 1 : 0;
        this.buts[3] = (this.driver.handle.buttons & 8) != 0 ? 1 : 0;
        this.buts[4] = (this.driver.handle.buttons & 0x10) != 0 ? 1 : 0;
        this.buts[5] = (this.driver.handle.buttons & 0x20) != 0 ? 1 : 0;
        this.sensorRead.setButtons(this.buts);
        this.sensorRead.setTime(System.currentTimeMillis());
        this.sensorRead.set(this.transform);
        this.sensor.setNextSensorRead(this.sensorRead);
    }

    public void processStreamInput() {
    }

    public void setNominalPositionAndOrientation() {
    }

    public void setProcessingMode(int n) {
    }

    public void setRotationScale(float f) {
        this.rotationScale = f;
    }

    public void setTranslationScale(float f) {
        this.positionScale = f;
    }
}

