/*
 * Decompiled with CFR 0.152.
 */
package ncsa.devices.mouse;

import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.vecmath.Vector3f;
import ncsa.devices.Fake2DInputDevice;
import ncsa.j3d.ui.events.EventManager;
import ncsa.j3d.ui.events.MouseDown;
import ncsa.j3d.ui.events.MouseDrag;
import ncsa.j3d.ui.events.MouseUp;
import ncsa.j3d.ui.events.PortfolioEventReceiver;

public class MouseDevice
implements PortfolioEventReceiver,
Fake2DInputDevice {
    public static final int MAX_BUTTONS = 3;
    int[] buttons = new int[3];
    Vector3f vector = new Vector3f();

    public MouseDevice() {
        EventManager eventManager = EventManager.instance();
        eventManager.addBehavior(new MouseDown(this));
        eventManager.addBehavior(new MouseDrag(this));
        eventManager.addBehavior(new MouseUp(this));
    }

    protected int buttonState(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501 || mouseEvent.getID() == 506) {
            return 1;
        }
        return 0;
    }

    public int[] getButtons() {
        return this.buttons;
    }

    public Vector3f getVector3f() {
        return this.vector;
    }

    protected boolean left(MouseEvent mouseEvent) {
        return (0x10 & mouseEvent.getModifiers()) > 0;
    }

    protected boolean middle(MouseEvent mouseEvent) {
        return (8 & mouseEvent.getModifiers()) > 0;
    }

    public boolean notify(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            this.vector.x = mouseEvent.getX();
            this.vector.y = mouseEvent.getY();
            this.vector.z = 0.0f;
            this.buttons[0] = this.left(mouseEvent) ? this.buttonState(mouseEvent) : 0;
            this.buttons[1] = this.middle(mouseEvent) ? this.buttonState(mouseEvent) : 0;
            this.buttons[2] = this.right(mouseEvent) ? this.buttonState(mouseEvent) : 0;
            return true;
        }
        return false;
    }

    protected boolean right(MouseEvent mouseEvent) {
        return (4 & mouseEvent.getModifiers()) > 0;
    }
}

