/*
 * Decompiled with CFR 0.152.
 */
package ncsa.devices.joystick;

import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.media.j3d.SensorRead;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3f;
import ncsa.devices.Fake2DInputDevice;

public class PCJoystickDevice
implements InputDevice,
Runnable,
Fake2DInputDevice {
    protected Thread thread;
    public int x;
    public int y;
    public int z;
    public int r;
    public int u;
    public int v;
    public int pov;
    public int buttons;
    public float rotationScale = 1.5707964f;
    public float translationScale = 25.0f;
    public final int BUTTONS = 8;
    final float MAX_VALUE = 65472.0f;
    final float CENTER = 32736.0f;
    final float zero = 512.0f;
    protected Transform3D transform = new Transform3D();
    protected Transform3D working = new Transform3D();
    protected Sensor sensor;
    protected SensorRead sensorRead = new SensorRead();
    protected Vector3f vector = new Vector3f();
    protected int[] button = new int[8];

    static {
        System.loadLibrary("ncsapcjoystick");
    }

    public PCJoystickDevice() {
        this.sensor = new Sensor((InputDevice)this, 30, 8);
        this.sensorRead = new SensorRead(8);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public native void close();

    protected void computeTransform() {
        float f = -(((float)this.getR() - 32736.0f) / 32736.0f) * this.rotationScale;
        this.transform.rotY((double)f);
        Vector3f vector3f = this.getVector3f();
        vector3f.x = (vector3f.x - 32736.0f) / 32736.0f * this.translationScale;
        vector3f.y = -((vector3f.y - 32736.0f) / 32736.0f) * this.translationScale;
        vector3f.z = ((vector3f.z - 32736.0f) / 32736.0f + 0.5f) * this.translationScale;
        this.transform.setTranslation(vector3f);
    }

    protected int getButton() {
        return this.buttons;
    }

    public int[] getButtons() {
        this.button[0] = (this.buttons & 1) != 0 ? 1 : 0;
        this.button[1] = (this.buttons & 2) != 0 ? 1 : 0;
        this.button[2] = (this.buttons & 4) != 0 ? 1 : 0;
        this.button[3] = (this.buttons & 8) != 0 ? 1 : 0;
        this.button[4] = (this.buttons & 0x10) != 0 ? 1 : 0;
        this.button[5] = (this.buttons & 0x20) != 0 ? 1 : 0;
        this.button[6] = (this.buttons & 0x40) != 0 ? 1 : 0;
        this.button[7] = (this.buttons & 0x80) != 0 ? 1 : 0;
        return this.button;
    }

    protected int getPOV() {
        return this.pov;
    }

    public int getProcessingMode() {
        return 5;
    }

    protected int getR() {
        return this.r;
    }

    public Sensor getSensor(int n) {
        return this.sensor;
    }

    public int getSensorCount() {
        return 1;
    }

    protected int getU() {
        return this.u;
    }

    protected int getV() {
        return this.v;
    }

    public Vector3f getVector3f() {
        this.vector.x = this.x;
        this.vector.y = this.y;
        this.vector.z = this.z;
        return this.vector;
    }

    protected int getX() {
        return this.x;
    }

    protected int getY() {
        return this.y;
    }

    protected int getZ() {
        return this.z;
    }

    public boolean initialize() {
        return true;
    }

    public static void main(String[] stringArray) {
        PCJoystickDevice pCJoystickDevice = new PCJoystickDevice();
        while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            System.out.println(String.valueOf(pCJoystickDevice.getX()) + " " + pCJoystickDevice.getY() + " " + pCJoystickDevice.getZ() + " " + pCJoystickDevice.getR() + " " + pCJoystickDevice.getU() + " " + pCJoystickDevice.getV() + " " + pCJoystickDevice.getPOV() + " " + pCJoystickDevice.getButton());
        }
    }

    public final void pollAndProcessInput() {
        this.computeTransform();
        this.sensorRead.setTime(System.currentTimeMillis());
        this.sensorRead.setButtons(this.getButtons());
        this.sensorRead.set(this.transform);
        this.sensor.setNextSensorRead(this.sensorRead);
    }

    public native void process();

    public void processStreamInput() {
    }

    public void run() {
        this.process();
    }

    public void setNominalPositionAndOrientation() {
    }

    public void setProcessingMode(int n) {
    }

    public void shutdown() {
    }
}

