/*
 * Decompiled with CFR 0.152.
 */
package ncsa.devices.generic2d;

import javax.media.j3d.Transform3D;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import ncsa.devices.AdjustmentValues;
import ncsa.devices.Fake2DInputDevice;
import ncsa.devices.NCSAInputDevice;
import ncsa.j3d.ui.PortfolioProperties;

public class Generic2DInputDevice
extends NCSAInputDevice {
    Fake2DInputDevice input = null;
    Transform3D transform = new Transform3D();
    Vector3f vector = new Vector3f();
    Vector3f rotation = new Vector3f();
    int[] lastbuttons;
    boolean mode = false;
    AdjustmentValues adjust;

    protected boolean buttonTransition(int n) {
        if (this.lastbuttons == null) {
            return false;
        }
        return this.buttons[0][n] != this.lastbuttons[n];
    }

    protected void computeXY() {
        if (this.mode) {
            this.rotateXY();
        } else {
            this.translateXY();
        }
    }

    protected void computeZ() {
        if (this.mode) {
            this.rotateZ();
        } else {
            this.translateZ();
        }
    }

    protected void maintainButtonList() {
        if (this.lastbuttons == null || this.buttons[0].length != this.lastbuttons.length) {
            this.lastbuttons = new int[this.buttons[0].length];
        }
        int n = 0;
        while (n < this.buttons[0].length) {
            this.lastbuttons[n] = this.buttons[0][n];
            ++n;
        }
    }

    public void pollAndProcessInput() {
        this.setButtons(0, this.input.getButtons());
        if (this.buttonTransition(0) || this.buttonTransition(1)) {
            this.vector.set((Tuple3f)this.input.getVector3f());
        }
        if (this.buttonTransition(2) && this.buttons[0][2] != 0) {
            this.mode ^= true;
        }
        if (this.buttons[0][0] != 0) {
            this.computeXY();
        }
        if (this.buttons[0][1] != 0) {
            this.computeZ();
        }
        this.maintainButtonList();
        this.sensorReads[0].setTime(System.currentTimeMillis());
        this.sensorReads[0].set(this.transform);
        this.sensorReads[0].setButtons(this.buttons[0]);
        this.sensors[0].setNextSensorRead(this.sensorReads[0]);
    }

    public void portfolioDeviceInitializing() {
        this.adjust = new AdjustmentValues(this);
        PortfolioProperties portfolioProperties = PortfolioProperties.instance();
        Object object = portfolioProperties.getObject(String.valueOf(this.name) + ".Input");
        if (object == null) {
            System.out.println("Generic2DInputDevice: NOT PROPERLY CONSTRUCTED.");
            System.out.print("Please define " + this.name + ".Input in ");
            System.out.println("portfolio.properties file.");
            return;
        }
        if (object instanceof Fake2DInputDevice) {
            this.input = (Fake2DInputDevice)object;
            int[] nArray = this.input.getButtons();
            if (nArray.length > this.buttons[0].length) {
                this.buildSensorWithButtons(0, nArray.length);
            }
        } else {
            System.out.println("Generic2DInputDevice: NOT PROPERLY CONSTRUCTED.");
            System.out.println(String.valueOf(portfolioProperties.getProperty(String.valueOf(this.name) + ".Input")) + " does not" + " implement ncsa.devices.Fake2DInputDevice");
        }
    }

    protected void rotateXY() {
        Vector3f vector3f = new Vector3f(this.input.getVector3f());
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f(vector3f);
        vector3f.sub((Tuple3f)this.vector);
        vector3f.z = vector3f.x;
        vector3f.x = vector3f.y;
        vector3f.y = vector3f.z;
        vector3f.z = 0.0f;
        this.adjust.applyR(vector3f);
        this.rotation.add((Tuple3f)vector3f);
        this.transform.get(vector3f2);
        this.setRotation();
        this.transform.setTranslation(vector3f2);
        this.vector = vector3f3;
    }

    protected void rotateZ() {
        Vector3f vector3f = new Vector3f(this.input.getVector3f());
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f(vector3f);
        vector3f.sub((Tuple3f)this.vector);
        vector3f.z = vector3f.x;
        vector3f.x = 0.0f;
        vector3f.y = 0.0f;
        this.adjust.applyR(vector3f);
        this.rotation.add((Tuple3f)vector3f);
        this.transform.get(vector3f2);
        this.setRotation();
        this.transform.setTranslation(vector3f2);
        this.vector = vector3f3;
    }

    protected void setRotation() {
        Transform3D transform3D = new Transform3D();
        this.transform.setIdentity();
        transform3D.rotX((double)this.rotation.x);
        this.transform.mul(transform3D);
        transform3D.rotY((double)this.rotation.y);
        this.transform.mul(transform3D);
        transform3D.rotZ((double)this.rotation.z);
        this.transform.mul(transform3D);
    }

    protected void translateXY() {
        Vector3f vector3f = new Vector3f(this.input.getVector3f());
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f(vector3f);
        vector3f.sub((Tuple3f)this.vector);
        this.adjust.apply(vector3f);
        this.transform.get(vector3f2);
        vector3f.add((Tuple3f)vector3f2);
        this.transform.setTranslation(vector3f);
        this.vector = vector3f3;
    }

    protected void translateZ() {
        Vector3f vector3f = new Vector3f(this.input.getVector3f());
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f(vector3f);
        vector3f.sub((Tuple3f)this.vector);
        vector3f.x = 0.0f;
        vector3f.z = vector3f.y;
        vector3f.y = 0.0f;
        this.adjust.apply(vector3f);
        this.transform.get(vector3f2);
        vector3f.add((Tuple3f)vector3f2);
        this.transform.setTranslation(vector3f);
        this.vector = vector3f3;
    }
}

