/*
 * Decompiled with CFR 0.152.
 */
package ncsa.devices.bird;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class BirdDriver {
    SerialPort serialPort = null;
    InputStream inputStream = null;
    OutputStream outputStream = null;
    int birds = 1;

    public BirdDriver(String string, int n) {
        CommPortIdentifier commPortIdentifier = this.getPortId(string);
        this.setup(commPortIdentifier, n);
    }

    public void addEventListener(SerialPortEventListener serialPortEventListener) {
        try {
            this.serialPort.addEventListener(serialPortEventListener);
            this.serialPort.notifyOnDataAvailable(true);
        }
        catch (TooManyListenersException tooManyListenersException) {
            System.out.println("BirdDriver.setup");
            System.out.println(tooManyListenersException);
        }
    }

    protected void configureFlock() {
        byte[] byArray = new byte[]{80, 50, (byte)this.birds};
        this.write(byArray);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    protected CommPortIdentifier getPortId(String string) {
        if (string == null) {
            return null;
        }
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        while (enumeration.hasMoreElements()) {
            CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            if (commPortIdentifier.getPortType() != 1 || !commPortIdentifier.getName().equals(string)) continue;
            return commPortIdentifier;
        }
        System.out.println("BIRD_ERROR: could not find port " + string);
        System.out.println("Please change the BirdPort variable in portfolio.properties.");
        return null;
    }

    public byte lsb(float f) {
        short s = (short)(f / 180.0f * 32767.0f);
        return (byte)(s & 0xFF);
    }

    public byte msb(float f) {
        short s = (short)(f / 180.0f * 32767.0f);
        return (byte)(s >> 8 & 0xFF);
    }

    public void selectBird(int n) {
        byte[] byArray = new byte[]{(byte)(240 + n)};
        this.write(byArray);
    }

    protected void sendFilters(boolean bl) {
        byte[] byArray = new byte[]{80, 4, (byte)(bl ? 0 : 7), 0};
        this.write(byArray);
    }

    protected void sendGroupMode() {
        byte[] byArray = new byte[]{80, 35, 1};
        this.write(byArray);
    }

    protected void sendHemisphere(String string) {
        byte[] byArray = new byte[3];
        byArray[0] = 76;
        if (string.equalsIgnoreCase("FRONT")) {
            byArray[1] = 0;
            byArray[2] = 0;
        }
        if (string.equalsIgnoreCase("AFT")) {
            byArray[1] = 0;
            byArray[2] = 1;
        }
        if (string.equalsIgnoreCase("UPPER")) {
            byArray[1] = 12;
            byArray[2] = 1;
        }
        if (string.equalsIgnoreCase("LOWER")) {
            byArray[1] = 12;
            byArray[2] = 0;
        }
        if (string.equalsIgnoreCase("LEFT")) {
            byArray[1] = 6;
            byArray[2] = 1;
        }
        if (string.equalsIgnoreCase("RIGHT")) {
            byArray[1] = 6;
            byArray[2] = 0;
        }
        this.write(byArray);
    }

    public void sendPositionAngles() {
        byte[] byArray = new byte[]{89};
        this.write(byArray);
    }

    public void sendPositionMatrix() {
        byte[] byArray = new byte[]{90};
        this.write(byArray);
    }

    public void sendReferenceFrame(float f, float f2, float f3) {
        byte[] byArray = new byte[7];
        byArray[0] = 114;
        byte by = this.msb(f3);
        byte by2 = this.lsb(f3);
        byArray[1] = (byte)(0 | by2 >> 2 | 0x80);
        byArray[2] = (byte)(by >> 1);
        by = this.msb(f2);
        by2 = this.lsb(f2);
        byArray[3] = (byte)(0 | by2 >> 2);
        byArray[4] = (byte)(by >> 1);
        by = this.msb(f);
        by2 = this.lsb(f);
        byArray[5] = (byte)(0 | by2 >> 2);
        byArray[6] = (byte)(by >> 1);
        this.write(byArray);
    }

    public void sendReferenceFrameXYZ(boolean bl) {
        byte[] byArray = new byte[]{80, 17, 1};
        this.write(byArray);
    }

    protected void sendReportRate(int n) {
        byte[] byArray = new byte[1];
        switch (n) {
            case 2: {
                byArray[0] = 82;
                break;
            }
            case 8: {
                byArray[0] = 83;
                break;
            }
            case 32: {
                byArray[0] = 84;
                break;
            }
            default: {
                byArray[0] = 81;
            }
        }
        this.write(byArray);
    }

    protected void sendStreamMode() {
        byte[] byArray = new byte[]{64};
        this.write(byArray);
    }

    public void setFilters(boolean bl) {
        this.sendFilters(bl);
    }

    public void setGroupMode(int n) {
        this.birds = n;
        this.sendGroupMode();
        this.configureFlock();
    }

    public void setHemisphere(String string) {
        int n = 0;
        while (n < this.birds) {
            this.selectBird(n + 1);
            this.sendHemisphere(string);
            ++n;
        }
    }

    public void setPositionAngles() {
        int n = 0;
        while (n < this.birds) {
            this.selectBird(n + 1);
            this.sendPositionAngles();
            ++n;
        }
    }

    public void setPositionMatrix() {
        int n = 0;
        while (n < this.birds) {
            this.selectBird(n + 1);
            this.sendPositionMatrix();
            ++n;
        }
    }

    public void setReportRate(int n) {
        this.selectBird(1);
        this.sendReportRate(n);
    }

    public void setStreamMode() {
        this.selectBird(1);
        this.sendStreamMode();
    }

    protected void setup(CommPortIdentifier commPortIdentifier, int n) {
        try {
            this.serialPort = (SerialPort)commPortIdentifier.open("BirdDriver", 2000);
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
            this.serialPort.setSerialPortParams(n, 8, 1, 0);
        }
        catch (IOException iOException) {
            System.out.println("BirdDriver.setup(CommPortIdentifier)");
            System.out.println(iOException);
        }
        catch (PortInUseException portInUseException) {
            System.out.println("BirdDriver.setup PORT IN USE");
            System.out.println((Object)portInUseException);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            System.out.println("BirdDriver.setup");
            System.out.println((Object)unsupportedCommOperationException);
        }
    }

    protected void write(byte[] byArray) {
        try {
            this.outputStream.write(byArray);
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            Thread.dumpStack();
        }
    }
}

