/*
 * Decompiled with CFR 0.152.
 */
package ncsa.devices.bird;

import java.io.IOException;
import java.io.PushbackInputStream;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3d;
import ncsa.devices.AdjustableInterface;
import ncsa.devices.AdjustmentInterface;
import ncsa.devices.AdjustmentValues;
import ncsa.devices.NCSAInputDevice;
import ncsa.devices.ValuesWithRotation;
import ncsa.devices.bird.BirdDriver;
import ncsa.devices.bird.intermediate;
import ncsa.j3d.ui.PortfolioProperties;

public class BirdAngleDevice
extends NCSAInputDevice
implements SerialPortEventListener,
AdjustableInterface,
ValuesWithRotation {
    int RECORD_SIZE = 0;
    byte[] buffer;
    int count = 0;
    float[][] data;
    int X = 0;
    int Y = 1;
    int Z = 2;
    int XR = 3;
    int YR = 4;
    int ZR = 5;
    BirdDriver driver = null;
    PushbackInputStream inputStream = null;
    String port;
    String hemisphere;
    int bps;
    int rate;
    boolean filters;
    boolean angleFormat = true;
    boolean streaming;
    boolean debug;
    Transform3D transform = new Transform3D();
    Transform3D temp = new Transform3D();
    Vector3d vector = new Vector3d();
    float[] matrix = new float[16];
    AdjustmentValues adjust;

    protected final void alignBoundary() throws IOException {
        boolean bl = false;
        int n = 0;
        while (this.inputStream.available() > 0 && !bl) {
            this.inputStream.read(this.buffer, 0, 1);
            if ((this.buffer[0] & 0x80) != 0) {
                bl = true;
                this.inputStream.unread(this.buffer, 0, 1);
            }
            ++n;
        }
    }

    protected void allocateSpace() {
        this.RECORD_SIZE = this.angleFormat ? 12 : 24;
        this.RECORD_SIZE += this.getSensorCount() > 1 ? 1 : 0;
        this.buffer = new byte[this.RECORD_SIZE + 1];
        this.data = new float[this.getSensorCount()][];
        int n = 0;
        while (n < this.data.length) {
            this.data[n] = new float[16];
            this.data[n][0] = 1.0f;
            this.data[n][5] = 1.0f;
            this.data[n][10] = 1.0f;
            this.data[n][15] = 1.0f;
            ++n;
        }
    }

    protected final float b2f(byte by, byte by2) {
        short s = (short)((by & 0x7F) << 9 | (by2 & 0x7F) << 2);
        return (float)s / 32767.0f;
    }

    public AdjustmentInterface getAdjustmentInterface() {
        return new intermediate(this.adjust, this);
    }

    public float getValue(int n, int n2) {
        return this.data[n][n2];
    }

    public final float getX(int n) {
        float f = this.data[n][this.X] * this.adjust.getPositionScale();
        f = this.adjust.getInversion(n, 0) ? -f : f;
        return f += this.adjust.getOffset(n, 0);
    }

    public int getXIndex() {
        return this.X;
    }

    public final float getXR(int n) {
        float f = this.adjust.getInversion(n, 3) ? -this.data[n][this.XR] : this.data[n][this.XR];
        return f * this.adjust.getRotationScale() + this.adjust.getOffset(n, 3);
    }

    public int getXRIndex() {
        return this.XR;
    }

    public final float getY(int n) {
        float f = this.data[n][this.Y] * this.adjust.getPositionScale();
        f = this.adjust.getInversion(n, 1) ? -f : f;
        return f += this.adjust.getOffset(n, 1);
    }

    public int getYIndex() {
        return this.Y;
    }

    public final float getYR(int n) {
        float f = this.adjust.getInversion(n, 4) ? -this.data[n][this.YR] : this.data[n][this.YR];
        return f * this.adjust.getRotationScale() + this.adjust.getOffset(n, 4);
    }

    public int getYRIndex() {
        return this.YR;
    }

    public final float getZ(int n) {
        float f = this.data[n][this.Z] * this.adjust.getPositionScale();
        f = this.adjust.getInversion(n, 2) ? -f : f;
        return f += this.adjust.getOffset(n, 2);
    }

    public int getZIndex() {
        return this.Z;
    }

    public final float getZR(int n) {
        float f = this.adjust.getInversion(n, 5) ? -this.data[n][this.ZR] : this.data[n][this.ZR];
        return f * this.adjust.getRotationScale() + this.adjust.getOffset(n, 5);
    }

    public int getZRIndex() {
        return this.ZR;
    }

    public static void main(String[] stringArray) {
        BirdAngleDevice birdAngleDevice = new BirdAngleDevice();
        birdAngleDevice.initializePortfolioDevice("BirdAngleDevice");
        int n = 0;
        if (stringArray.length > 0) {
            n = Integer.parseInt(stringArray[0]);
        }
        int n2 = 0;
        if (stringArray.length > 1) {
            n2 = Integer.parseInt(stringArray[1]);
        }
        while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
            if (n2 == 0 || n2 == 1) {
                System.out.print(String.valueOf(birdAngleDevice.getX(n)) + " ");
            }
            if (n2 == 0 || n2 == 2) {
                System.out.print(String.valueOf(birdAngleDevice.getY(n)) + " ");
            }
            if (n2 == 0 || n2 == 3) {
                System.out.print(String.valueOf(birdAngleDevice.getZ(n)) + " ");
            }
            if (n2 == 0 || n2 == 4) {
                System.out.print(String.valueOf(birdAngleDevice.getXR(n)) + " ");
            }
            if (n2 == 0 || n2 == 5) {
                System.out.print(String.valueOf(birdAngleDevice.getYR(n)) + " ");
            }
            if (n2 == 0 || n2 == 6) {
                System.out.print(String.valueOf(birdAngleDevice.getZR(n)) + " ");
            }
            System.out.println();
        }
    }

    protected void parseProperties() {
        PortfolioProperties portfolioProperties = PortfolioProperties.instance();
        this.port = portfolioProperties.getProperty(String.valueOf(this.name) + ".Port");
        String string = portfolioProperties.getProperty(String.valueOf(this.name) + ".Bps");
        this.hemisphere = portfolioProperties.getProperty(String.valueOf(this.name) + ".Hemisphere");
        String string2 = portfolioProperties.getProperty(String.valueOf(this.name) + ".Filters");
        String string3 = portfolioProperties.getProperty(String.valueOf(this.name) + ".Streaming");
        String string4 = portfolioProperties.getProperty(String.valueOf(this.name) + ".ReportRate");
        if (portfolioProperties.getProperty(String.valueOf(this.name) + "Debug") != null) {
            this.debug = true;
        }
        this.port = this.port == null ? "com1" : this.port;
        string = string == null ? "115200" : string;
        this.hemisphere = this.hemisphere == null ? "LOWER" : this.hemisphere;
        string2 = string2 == null ? "true" : string2;
        string3 = string3 == null ? "true" : string3;
        string4 = string4 == null ? "8" : string4;
        this.bps = Integer.parseInt(string);
        this.rate = Integer.parseInt(string4);
        this.filters = string2.equalsIgnoreCase("true");
        this.streaming = string3.equalsIgnoreCase("true");
        String string5 = portfolioProperties.getProperty(String.valueOf(this.name) + "X");
        if (string5 != null) {
            this.X = Integer.parseInt(string5);
        }
        if ((string5 = portfolioProperties.getProperty(String.valueOf(this.name) + "Y")) != null) {
            this.Y = Integer.parseInt(string5);
        }
        if ((string5 = portfolioProperties.getProperty(String.valueOf(this.name) + "Z")) != null) {
            this.Z = Integer.parseInt(string5);
        }
        if ((string5 = portfolioProperties.getProperty(String.valueOf(this.name) + "XR")) != null) {
            this.XR = Integer.parseInt(string5);
        }
        if ((string5 = portfolioProperties.getProperty(String.valueOf(this.name) + "YR")) != null) {
            this.YR = Integer.parseInt(string5);
        }
        if ((string5 = portfolioProperties.getProperty(String.valueOf(this.name) + "ZR")) != null) {
            this.ZR = Integer.parseInt(string5);
        }
    }

    public final void pollAndProcessInput() {
        int n = 0;
        while (n < this.getSensorCount()) {
            this.prepareAngleData(n);
            this.sensorReads[n].setTime(System.currentTimeMillis());
            this.sensorReads[n].set(this.transform);
            this.sensors[n].setNextSensorRead(this.sensorReads[n]);
            ++n;
        }
    }

    public void portfolioDeviceInitializing() {
        this.parseProperties();
        this.allocateSpace();
        this.adjust = new AdjustmentValues(this.name, this.getSensorCount());
        if (this.debug) {
            this.printDebug();
        }
        this.driver = new BirdDriver(this.port, this.bps);
        this.inputStream = new PushbackInputStream(this.driver.getInputStream());
        this.driver.addEventListener(this);
        if (this.getSensorCount() > 1) {
            this.driver.setGroupMode(this.getSensorCount());
        }
        if (this.filters) {
            this.driver.setFilters(true);
        } else {
            this.driver.setFilters(false);
        }
        this.driver.setHemisphere(this.hemisphere);
        this.driver.setPositionAngles();
        if (this.streaming) {
            this.driver.setReportRate(this.rate);
            this.driver.setStreamMode();
        }
        if (PortfolioProperties.instance().getProperty(String.valueOf(this.name) + "RotationScale") == null) {
            this.adjust.setRotationScale(1.5707964f);
        }
    }

    public final void prepareAngleData(int n) {
        this.vector.x = this.getX(n);
        this.vector.y = this.getY(n);
        this.vector.z = this.getZ(n);
        this.transform.set(this.vector);
        this.temp.rotX((double)this.getXR(n));
        this.transform.mul(this.temp);
        this.temp.rotY((double)this.getYR(n));
        this.transform.mul(this.temp);
        this.temp.rotZ((double)this.getZR(n));
        this.transform.mul(this.temp);
    }

    protected void printDebug() {
        System.out.println("Bird on port " + this.port);
        System.out.println("Bird running at " + this.bps + " bps");
        System.out.println("Bird is streaming " + this.streaming);
        System.out.println("Bird outputing angles " + this.angleFormat);
        System.out.println("Bird configured for " + this.hemisphere + " hemisphere");
        System.out.println("Bird filters are on " + this.filters);
        if (this.streaming) {
            System.out.println("Bird sampling every " + this.rate + " clock cycles");
        }
        System.out.println("X " + this.X + " Y " + this.Y + " Z " + this.Z + " XR " + this.XR + " YR " + this.YR + " ZR " + this.ZR);
    }

    protected final void processAngles() {
        if (this.count < 13) {
            return;
        }
        int n = this.buffer[12] - 1;
        this.data[n][0] = this.b2f(this.buffer[1], this.buffer[0]);
        this.data[n][1] = this.b2f(this.buffer[3], this.buffer[2]);
        this.data[n][2] = this.b2f(this.buffer[5], this.buffer[4]);
        this.data[n][3] = this.b2f(this.buffer[7], this.buffer[6]);
        this.data[n][4] = this.b2f(this.buffer[9], this.buffer[8]);
        this.data[n][5] = this.b2f(this.buffer[11], this.buffer[10]);
    }

    public final void serialEvent(SerialPortEvent serialPortEvent) {
        switch (serialPortEvent.getEventType()) {
            case 1: {
                try {
                    while (this.inputStream.available() >= this.RECORD_SIZE) {
                        this.count += this.inputStream.read(this.buffer, this.count, this.RECORD_SIZE - this.count);
                        if ((this.buffer[0] & 0x80) == 0) {
                            this.alignBoundary();
                            this.count = 0;
                            continue;
                        }
                        this.processAngles();
                        this.count = 0;
                    }
                }
                catch (IOException iOException) {
                    System.out.println("WandDriver.serialEvent");
                    System.out.println(iOException);
                }
                break;
            }
        }
    }

    public void setXIndex(int n) {
        this.X = n;
    }

    public void setXRIndex(int n) {
        this.XR = n;
    }

    public void setYIndex(int n) {
        this.Y = n;
    }

    public void setYRIndex(int n) {
        this.YR = n;
    }

    public void setZIndex(int n) {
        this.Z = n;
    }

    public void setZRIndex(int n) {
        this.ZR = n;
    }
}

