/*
 * Decompiled with CFR 0.152.
 */
package ncsa.devices;

import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.media.j3d.SensorRead;
import ncsa.j3d.ui.PortfolioProperties;

public class NCSAInputDevice
implements InputDevice {
    protected Sensor[] sensors;
    protected SensorRead[] sensorReads;
    protected int[][] buttons;
    private int processingMode = 5;
    protected String name = this.generateUniqueName();
    static int count = 0;

    protected NCSAInputDevice() {
    }

    protected void buildSensorWithButtons(int n, int n2) {
        this.buttons[n] = new int[n2];
        this.sensors[n] = new Sensor((InputDevice)this, 30, n2);
        this.sensorReads[n] = new SensorRead(n2);
    }

    public void close() {
    }

    protected String generateUniqueName() {
        return "InputDevice" + count++;
    }

    public String getName() {
        return this.name;
    }

    public int getProcessingMode() {
        return this.processingMode;
    }

    public Sensor getSensor(int n) {
        return this.sensors[n];
    }

    public int getSensorCount() {
        return this.sensors.length;
    }

    public boolean initialize() {
        return true;
    }

    public void initializePortfolioDevice() {
        this.setupSensors();
        this.portfolioDeviceInitializing();
    }

    public void initializePortfolioDevice(String string) {
        if (string != null) {
            this.name = string;
        }
        this.initializePortfolioDevice();
    }

    public void pollAndProcessInput() {
    }

    protected void portfolioDeviceInitializing() {
    }

    public void processStreamInput() {
    }

    protected void setButtons(int n, int[] nArray) {
        int n2 = 0;
        while (n2 < this.buttons[n].length) {
            this.buttons[n][n2] = nArray[n2];
            ++n2;
        }
    }

    public void setNominalPositionAndOrientation() {
    }

    public void setProcessingMode(int n) {
        switch (n) {
            case 3: 
            case 4: 
            case 5: {
                this.processingMode = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Processing mode must be one of DEMAND_DRIVEN, NON_BLOCKING, or BLOCKING");
            }
        }
    }

    protected void setupSensors() {
        PortfolioProperties portfolioProperties = PortfolioProperties.instance();
        String string = portfolioProperties.getProperty(String.valueOf(this.name) + ".Sensors");
        int n = string == null ? 1 : Integer.parseInt(string);
        this.sensors = new Sensor[n];
        this.sensorReads = new SensorRead[n];
        this.buttons = new int[n][];
        int n2 = 0;
        while (n2 < n) {
            string = portfolioProperties.getProperty(String.valueOf(this.name) + ".Sensor" + n2 + ".Buttons");
            int n3 = string == null ? 0 : Integer.parseInt(string);
            this.buildSensorWithButtons(n2, n3);
            ++n2;
        }
    }
}

