/*
 * Decompiled with CFR 0.152.
 */
package ncsa.devices;

import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import ncsa.devices.AdjustmentInterface;
import ncsa.devices.NCSAInputDevice;
import ncsa.j3d.ui.PortfolioProperties;

public class AdjustmentValues
implements AdjustmentInterface {
    protected float[][] offsets;
    protected boolean[][] inversions;
    protected float rotScale = 1.0f;
    protected float posScale = 1.0f;
    protected String name;
    protected int sensorCount;
    protected Transform3D[] transforms;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int XR = 3;
    public static final int YR = 4;
    public static final int ZR = 5;

    public AdjustmentValues(String string, int n) {
        this.name = string;
        this.sensorCount = n;
        this.setupOffsets();
        this.setupInversions();
        this.setupScale();
        this.buildTransforms();
    }

    public AdjustmentValues(NCSAInputDevice nCSAInputDevice) {
        this(nCSAInputDevice.getName(), nCSAInputDevice.getSensorCount());
    }

    public void apply(int n, Vector3f vector3f) {
        vector3f.x *= this.posScale;
        vector3f.y *= this.posScale;
        vector3f.z *= this.posScale;
        vector3f.x = this.inversions[n][0] ? -vector3f.x : vector3f.x;
        vector3f.y = this.inversions[n][1] ? -vector3f.y : vector3f.y;
        vector3f.z = this.inversions[n][2] ? -vector3f.z : vector3f.z;
        vector3f.x += this.offsets[n][0];
        vector3f.y += this.offsets[n][1];
        vector3f.z += this.offsets[n][2];
    }

    public void apply(Vector3f vector3f) {
        this.apply(0, vector3f);
    }

    public void applyR(int n, Vector3f vector3f) {
        vector3f.x *= this.rotScale;
        vector3f.y *= this.rotScale;
        vector3f.z *= this.rotScale;
        vector3f.x = this.inversions[n][3] ? -vector3f.x : vector3f.x;
        vector3f.y = this.inversions[n][4] ? -vector3f.y : vector3f.y;
        vector3f.z = this.inversions[n][5] ? -vector3f.z : vector3f.z;
        vector3f.x += this.offsets[n][3];
        vector3f.y += this.offsets[n][4];
        vector3f.z += this.offsets[n][5];
    }

    public void applyR(Vector3f vector3f) {
        this.applyR(0, vector3f);
    }

    protected void buildTransforms() {
        Transform3D transform3D = new Transform3D();
        Transform3D transform3D2 = new Transform3D();
        Transform3D transform3D3 = new Transform3D();
        float[] fArray = new float[16];
        this.transforms = new Transform3D[this.sensorCount];
        int n = 0;
        while (n < this.sensorCount) {
            this.transforms[n] = new Transform3D();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.sensorCount) {
            transform3D3.setIdentity();
            transform3D3.get(fArray);
            if (this.inversions[n2][0]) {
                fArray[0] = -fArray[0];
            }
            if (this.inversions[n2][1]) {
                fArray[5] = -fArray[5];
            }
            if (this.inversions[n2][2]) {
                fArray[10] = -fArray[10];
            }
            transform3D3.set(fArray);
            this.transforms[n2].mul(transform3D3);
            ++n2;
        }
    }

    public boolean getInversion(int n, int n2) {
        return this.inversions[n][n2];
    }

    public float getOffset(int n, int n2) {
        return this.offsets[n][n2];
    }

    public float getPositionScale() {
        return this.posScale;
    }

    public float getRotationScale() {
        return this.rotScale;
    }

    public Vector3d getVector(int n) {
        return new Vector3d((double)this.getOffset(n, 0), (double)this.getOffset(n, 1), (double)this.getOffset(n, 2));
    }

    public boolean getXInversion(int n) {
        return this.getInversion(n, 0);
    }

    public float getXOffset(int n) {
        return this.getOffset(n, 0);
    }

    public boolean getXRInversion(int n) {
        return this.getInversion(n, 3);
    }

    public float getXROffset(int n) {
        return this.getOffset(n, 3);
    }

    public boolean getYInversion(int n) {
        return this.getInversion(n, 1);
    }

    public float getYOffset(int n) {
        return this.getOffset(n, 1);
    }

    public boolean getYRInversion(int n) {
        return this.getInversion(n, 4);
    }

    public float getYROffset(int n) {
        return this.getOffset(n, 4);
    }

    public boolean getZInversion(int n) {
        return this.getInversion(n, 2);
    }

    public float getZOffset(int n) {
        return this.getOffset(n, 2);
    }

    public boolean getZRInversion(int n) {
        return this.getInversion(n, 5);
    }

    public float getZROffset(int n) {
        return this.getOffset(n, 5);
    }

    public void setInversion(int n, int n2, boolean bl) {
        this.inversions[n][n2] = bl;
    }

    public void setOffset(int n, int n2, float f) {
        this.offsets[n][n2] = f;
    }

    public void setPositionScale(float f) {
        this.posScale = f;
    }

    public void setRotationScale(float f) {
        this.rotScale = f;
    }

    public void setXInversion(int n, boolean bl) {
        this.setInversion(n, 0, bl);
    }

    public void setXOffset(int n, float f) {
        this.setOffset(n, 0, f);
    }

    public void setXRInversion(int n, boolean bl) {
        this.setInversion(n, 3, bl);
    }

    public void setXROffset(int n, float f) {
        this.setOffset(n, 3, f);
    }

    public void setYInversion(int n, boolean bl) {
        this.setInversion(n, 1, bl);
    }

    public void setYOffset(int n, float f) {
        this.setOffset(n, 1, f);
    }

    public void setYRInversion(int n, boolean bl) {
        this.setInversion(n, 4, bl);
    }

    public void setYROffset(int n, float f) {
        this.setOffset(n, 4, f);
    }

    public void setZInversion(int n, boolean bl) {
        this.setInversion(n, 2, bl);
    }

    public void setZOffset(int n, float f) {
        this.setOffset(n, 2, f);
    }

    public void setZRInversion(int n, boolean bl) {
        this.setInversion(n, 5, bl);
    }

    public void setZROffset(int n, float f) {
        this.setOffset(n, 5, f);
    }

    protected void setupInversions() {
        PortfolioProperties portfolioProperties = PortfolioProperties.instance();
        this.inversions = new boolean[this.sensorCount][];
        int n = 0;
        while (n < this.sensorCount) {
            this.inversions[n] = new boolean[6];
            String string = portfolioProperties.getProperty(String.valueOf(this.name) + ".Sensor" + n + ".XInversion");
            if (string != null) {
                this.inversions[n][0] = string.equalsIgnoreCase("true");
            }
            if ((string = portfolioProperties.getProperty(String.valueOf(this.name) + ".Sensor" + n + ".YInversion")) != null) {
                this.inversions[n][1] = string.equalsIgnoreCase("true");
            }
            if ((string = portfolioProperties.getProperty(String.valueOf(this.name) + ".Sensor" + n + ".ZInversion")) != null) {
                this.inversions[n][2] = string.equalsIgnoreCase("true");
            }
            if ((string = portfolioProperties.getProperty(String.valueOf(this.name) + ".Sensor" + n + ".XRInversion")) != null) {
                this.inversions[n][3] = string.equalsIgnoreCase("true");
            }
            if ((string = portfolioProperties.getProperty(String.valueOf(this.name) + ".Sensor" + n + ".YRInversion")) != null) {
                this.inversions[n][4] = string.equalsIgnoreCase("true");
            }
            if ((string = portfolioProperties.getProperty(String.valueOf(this.name) + ".Sensor" + n + ".ZRInversion")) != null) {
                this.inversions[n][5] = string.equalsIgnoreCase("true");
            }
            ++n;
        }
    }

    protected void setupOffsets() {
        PortfolioProperties portfolioProperties = PortfolioProperties.instance();
        this.offsets = new float[this.sensorCount][];
        int n = 0;
        while (n < this.sensorCount) {
            this.offsets[n] = new float[6];
            String string = portfolioProperties.getProperty(String.valueOf(this.name) + ".Sensor" + n + ".XOffset");
            if (string != null) {
                this.offsets[n][0] = Float.parseFloat(string);
            }
            if ((string = portfolioProperties.getProperty(String.valueOf(this.name) + ".Sensor" + n + ".YOffset")) != null) {
                this.offsets[n][1] = Float.parseFloat(string);
            }
            if ((string = portfolioProperties.getProperty(String.valueOf(this.name) + ".Sensor" + n + ".ZOffset")) != null) {
                this.offsets[n][2] = Float.parseFloat(string);
            }
            if ((string = portfolioProperties.getProperty(String.valueOf(this.name) + ".Sensor" + n + ".XROffset")) != null) {
                this.offsets[n][3] = (float)((double)(Float.parseFloat(string) / 180.0f) * 1.5707963267948966);
            }
            if ((string = portfolioProperties.getProperty(String.valueOf(this.name) + ".Sensor" + n + ".YROffset")) != null) {
                this.offsets[n][4] = (float)((double)(Float.parseFloat(string) / 180.0f) * 1.5707963267948966);
            }
            if ((string = portfolioProperties.getProperty(String.valueOf(this.name) + ".Sensor" + n + ".ZROffset")) != null) {
                this.offsets[n][5] = (float)((double)(Float.parseFloat(string) / 180.0f) * 1.5707963267948966);
            }
            ++n;
        }
    }

    protected void setupScale() {
        PortfolioProperties portfolioProperties = PortfolioProperties.instance();
        String string = portfolioProperties.getProperty(String.valueOf(this.name) + ".RotationScale");
        if (string != null) {
            this.rotScale = Float.parseFloat(string);
        }
        if ((string = portfolioProperties.getProperty(String.valueOf(this.name) + ".PositionScale")) != null) {
            this.posScale = Float.parseFloat(string);
        }
    }
}

