/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import org.apache.xerces.utils.QName;
import org.apache.xerces.validators.common.CMAny;
import org.apache.xerces.validators.common.CMBinOp;
import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.CMLeaf;
import org.apache.xerces.validators.common.CMNode;
import org.apache.xerces.validators.common.CMStateSet;
import org.apache.xerces.validators.common.CMUniOp;
import org.apache.xerces.validators.common.ContentLeafNameTypeVector;
import org.apache.xerces.validators.common.InsertableElementsInfo;
import org.apache.xerces.validators.common.XMLContentModel;
import org.apache.xerces.validators.schema.EquivClassComparator;

public class DFAContentModel
implements XMLContentModel {
    private static final int EPSILON = -2;
    private static final int EOC = -3;
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private EquivClassComparator comparator = null;
    private QName[] fElemMap = null;
    private int[] fElemMapType = null;
    private int fElemMapSize = 0;
    private boolean fDTD;
    private int fEOCIndex = 0;
    private int fEOCPos = 0;
    private int fEpsilonIndex = 0;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private CMLeaf[] fLeafList = null;
    private int[] fLeafListType = null;
    private ContentLeafNameTypeVector fLeafNameTypeVector = null;
    private int[][] fTransTable = null;
    private int fTransTableSize = 0;
    private boolean fEmptyContentIsValid = false;
    private QName fQName = new QName();

    public DFAContentModel(CMNode cMNode, int n) throws CMException {
        this(cMNode, n, false);
    }

    public DFAContentModel(CMNode cMNode, int n, boolean bl) throws CMException {
        this.fLeafCount = n;
        this.fEpsilonIndex = -2;
        this.fEOCIndex = -3;
        this.fDTD = bl;
        this.buildDFA(cMNode);
    }

    public int validateContent(QName[] qNameArray, int n, int n2) throws CMException {
        if (n2 == 0) {
            return this.fEmptyContentIsValid ? -1 : 0;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            QName qName = qNameArray[n + n4];
            int n5 = 0;
            while (n5 < this.fElemMapSize) {
                int n6;
                int n7 = this.fElemMapType[n5] & 0xF;
                if (n7 == 0 ? (this.fDTD ? this.fElemMap[n5].rawname == qName.rawname : this.fElemMap[n5].uri == qName.uri && this.fElemMap[n5].localpart == qName.localpart) : (n7 == 6 ? (n6 = this.fElemMap[n5].uri) == -1 || n6 == qName.uri : (n7 == 8 ? qName.uri == -1 : n7 == 7 && this.fElemMap[n5].uri != qName.uri))) break;
                ++n5;
            }
            if (n5 == this.fElemMapSize) {
                return n4;
            }
            if ((n3 = this.fTransTable[n3][n5]) == -1) {
                return n4;
            }
            ++n4;
        }
        if (!this.fFinalStateFlags[n3]) {
            return n2;
        }
        return -1;
    }

    private boolean isEqual(QName qName, QName qName2) {
        return qName.localpart == qName2.localpart && qName.uri == qName2.uri;
    }

    public int validateContentSpecial(QName[] qNameArray, int n, int n2) throws Exception {
        if (this.comparator == null) {
            return this.validateContent(qNameArray, n, n2);
        }
        if (n2 == 0) {
            return this.fEmptyContentIsValid ? -1 : 0;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            QName qName = qNameArray[n + n4];
            int n5 = 0;
            while (n5 < this.fElemMapSize) {
                int n6;
                int n7 = this.fElemMapType[n5] & 0xF;
                if (n7 == 0 ? this.comparator.isEquivalentTo(qName, this.fElemMap[n5]) : (n7 == 6 ? (n6 = this.fElemMap[n5].uri) == -1 || n6 == qName.uri : (n7 == 8 ? qName.uri == -1 : n7 == 7 && this.fElemMap[n5].uri != qName.uri))) break;
                ++n5;
            }
            if (n5 == this.fElemMapSize) {
                return n4;
            }
            if ((n3 = this.fTransTable[n3][n5]) == -1) {
                return n4;
            }
            ++n4;
        }
        if (!this.fFinalStateFlags[n3]) {
            return n2;
        }
        return -1;
    }

    public void setEquivClassComparator(EquivClassComparator equivClassComparator) {
        this.comparator = equivClassComparator;
    }

    public int whatCanGoHere(boolean bl, InsertableElementsInfo insertableElementsInfo) throws CMException {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < insertableElementsInfo.insertAt) {
            QName qName = insertableElementsInfo.curChildren[n3];
            n = 0;
            while (n < this.fElemMapSize) {
                if (this.fElemMap[n].uri == qName.uri && this.fElemMap[n].localpart == qName.localpart) break;
                ++n;
            }
            if (n == this.fElemMapSize) {
                return n3;
            }
            if ((n2 = this.fTransTable[n2][n]) == -1) {
                return n3;
            }
            ++n3;
        }
        int n4 = n2;
        insertableElementsInfo.canHoldPCData = false;
        insertableElementsInfo.isValidEOC = this.fFinalStateFlags[n4];
        insertableElementsInfo.resultsCount = this.fElemMapSize;
        if (insertableElementsInfo.results == null || insertableElementsInfo.results.length < insertableElementsInfo.resultsCount) {
            insertableElementsInfo.results = new boolean[insertableElementsInfo.resultsCount];
        }
        if (insertableElementsInfo.possibleChildren == null || insertableElementsInfo.possibleChildren.length < insertableElementsInfo.resultsCount) {
            insertableElementsInfo.possibleChildren = new QName[insertableElementsInfo.resultsCount];
            n = 0;
            while (n < insertableElementsInfo.possibleChildren.length) {
                insertableElementsInfo.possibleChildren[n] = new QName();
                ++n;
            }
        }
        n = 0;
        while (n < this.fElemMapSize) {
            insertableElementsInfo.possibleChildren[n].setValues(this.fElemMap[n]);
            insertableElementsInfo.results[n] = this.fTransTable[n4][n] != -1;
            ++n;
        }
        if (bl) {
            int n5 = 0;
            while (n5 < insertableElementsInfo.resultsCount) {
                if (insertableElementsInfo.results[n5]) {
                    insertableElementsInfo.curChildren[insertableElementsInfo.insertAt] = insertableElementsInfo.possibleChildren[n5];
                    if (this.validateContent(insertableElementsInfo.curChildren, 0, insertableElementsInfo.childCount) != -1) {
                        insertableElementsInfo.results[n5] = false;
                    }
                }
                ++n5;
            }
        }
        return -1;
    }

    public ContentLeafNameTypeVector getContentLeafNameTypeVector() {
        return this.fLeafNameTypeVector;
    }

    private void buildDFA(CMNode cMNode) throws CMException {
        this.fQName.setValues(-1, this.fEOCIndex, this.fEOCIndex);
        CMLeaf cMLeaf = new CMLeaf(this.fQName);
        this.fHeadNode = new CMBinOp(5, cMNode, cMLeaf);
        this.fEOCPos = this.fLeafCount;
        cMLeaf.setPosition(this.fLeafCount++);
        this.fLeafList = new CMLeaf[this.fLeafCount];
        this.fLeafListType = new int[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode, 0);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        int n = 0;
        while (n < this.fLeafCount) {
            this.fFollowList[n] = new CMStateSet(this.fLeafCount);
            ++n;
        }
        this.calcFollowList(this.fHeadNode);
        this.fElemMap = new QName[this.fLeafCount];
        this.fElemMapType = new int[this.fLeafCount];
        this.fElemMapSize = 0;
        int n2 = 0;
        while (n2 < this.fLeafCount) {
            this.fElemMap[n2] = new QName();
            if ((this.fLeafListType[n2] & 0xF) != 0 && this.fLeafNameTypeVector == null) {
                this.fLeafNameTypeVector = new ContentLeafNameTypeVector();
            }
            QName qName = this.fLeafList[n2].getElement();
            int n3 = 0;
            while (n3 < this.fElemMapSize) {
                if (this.fDTD ? this.fElemMap[n3].rawname == qName.rawname : this.fElemMap[n3].uri == qName.uri && this.fElemMap[n3].localpart == qName.localpart && this.fElemMapType[n3] == this.fLeafListType[n2]) break;
                ++n3;
            }
            if (n3 == this.fElemMapSize) {
                this.fElemMap[this.fElemMapSize].setValues(qName);
                this.fElemMapType[this.fElemMapSize] = this.fLeafListType[n2];
                ++this.fElemMapSize;
            }
            ++n2;
        }
        if (this.fLeafNameTypeVector != null) {
            this.fLeafNameTypeVector.setValues(this.fElemMap, this.fElemMapType, this.fElemMapSize);
        }
        int n4 = this.fLeafCount * 4;
        CMStateSet[] cMStateSetArray = new CMStateSet[n4];
        this.fFinalStateFlags = new boolean[n4];
        this.fTransTable = new int[n4][];
        CMStateSet cMStateSet = this.fHeadNode.firstPos();
        int n5 = 0;
        int n6 = 0;
        this.fTransTable[n6] = this.makeDefStateList();
        cMStateSetArray[n6] = cMStateSet;
        ++n6;
        while (n5 < n6) {
            cMStateSet = cMStateSetArray[n5];
            int[] nArray = this.fTransTable[n5];
            this.fFinalStateFlags[n5] = cMStateSet.getBit(this.fEOCPos);
            ++n5;
            CMStateSet cMStateSet2 = null;
            int n7 = 0;
            while (n7 < this.fElemMapSize) {
                if (cMStateSet2 == null) {
                    cMStateSet2 = new CMStateSet(this.fLeafCount);
                } else {
                    cMStateSet2.zeroBits();
                }
                int n8 = 0;
                while (n8 < this.fLeafCount) {
                    if (cMStateSet.getBit(n8)) {
                        QName qName = this.fLeafList[n8].getElement();
                        QName qName2 = this.fElemMap[n7];
                        if (this.fDTD) {
                            if (qName.rawname == qName2.rawname) {
                                cMStateSet2.union(this.fFollowList[n8]);
                            }
                        } else if (qName.uri == qName2.uri && qName.localpart == qName2.localpart) {
                            cMStateSet2.union(this.fFollowList[n8]);
                        }
                    }
                    ++n8;
                }
                if (!cMStateSet2.isEmpty()) {
                    int n9 = 0;
                    while (n9 < n6) {
                        if (cMStateSetArray[n9].isSameSet(cMStateSet2)) break;
                        ++n9;
                    }
                    if (n9 == n6) {
                        cMStateSetArray[n6] = cMStateSet2;
                        this.fTransTable[n6] = this.makeDefStateList();
                        ++n6;
                        cMStateSet2 = null;
                    }
                    nArray[n7] = n9;
                    if (n6 == n4) {
                        int n10 = (int)((double)n4 * 1.5);
                        CMStateSet[] cMStateSetArray2 = new CMStateSet[n10];
                        boolean[] blArray = new boolean[n10];
                        int[][] nArrayArray = new int[n10][];
                        int n11 = 0;
                        while (n11 < n4) {
                            cMStateSetArray2[n11] = cMStateSetArray[n11];
                            blArray[n11] = this.fFinalStateFlags[n11];
                            nArrayArray[n11] = this.fTransTable[n11];
                            ++n11;
                        }
                        n4 = n10;
                        cMStateSetArray = cMStateSetArray2;
                        this.fFinalStateFlags = blArray;
                        this.fTransTable = nArrayArray;
                    }
                }
                ++n7;
            }
        }
        this.fEmptyContentIsValid = ((CMBinOp)this.fHeadNode).getLeft().isNullable();
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
    }

    private void calcFollowList(CMNode cMNode) throws CMException {
        if (cMNode.type() == 4) {
            this.calcFollowList(((CMBinOp)cMNode).getLeft());
            this.calcFollowList(((CMBinOp)cMNode).getRight());
        } else if (cMNode.type() == 5) {
            this.calcFollowList(((CMBinOp)cMNode).getLeft());
            this.calcFollowList(((CMBinOp)cMNode).getRight());
            CMStateSet cMStateSet = ((CMBinOp)cMNode).getLeft().lastPos();
            CMStateSet cMStateSet2 = ((CMBinOp)cMNode).getRight().firstPos();
            int n = 0;
            while (n < this.fLeafCount) {
                if (cMStateSet.getBit(n)) {
                    this.fFollowList[n].union(cMStateSet2);
                }
                ++n;
            }
        } else if (cMNode.type() == 2) {
            this.calcFollowList(((CMUniOp)cMNode).getChild());
            CMStateSet cMStateSet = cMNode.firstPos();
            CMStateSet cMStateSet3 = cMNode.lastPos();
            int n = 0;
            while (n < this.fLeafCount) {
                if (cMStateSet3.getBit(n)) {
                    this.fFollowList[n].union(cMStateSet);
                }
                ++n;
            }
        } else if (cMNode.type() == 3 || cMNode.type() == 1) {
            throw new CMException(10);
        }
    }

    private void dumpTree(CMNode cMNode, int n) throws CMException {
        int n2 = 0;
        while (n2 < n) {
            System.out.print("   ");
            ++n2;
        }
        int n3 = cMNode.type();
        if (n3 == 4 || n3 == 5) {
            if (n3 == 4) {
                System.out.print("Choice Node ");
            } else {
                System.out.print("Seq Node ");
            }
            if (cMNode.isNullable()) {
                System.out.print("Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(cMNode.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(cMNode.lastPos().toString());
            this.dumpTree(((CMBinOp)cMNode).getLeft(), n + 1);
            this.dumpTree(((CMBinOp)cMNode).getRight(), n + 1);
        } else if (cMNode.type() == 2) {
            System.out.print("Rep Node ");
            if (cMNode.isNullable()) {
                System.out.print("Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(cMNode.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(cMNode.lastPos().toString());
            this.dumpTree(((CMUniOp)cMNode).getChild(), n + 1);
        } else if (cMNode.type() == 0) {
            System.out.print("Leaf: (pos=" + ((CMLeaf)cMNode).getPosition() + "), " + ((CMLeaf)cMNode).getElement() + "(elemIndex=" + ((CMLeaf)cMNode).getElement() + ") ");
            if (cMNode.isNullable()) {
                System.out.print(" Nullable ");
            }
            System.out.print("firstPos=");
            System.out.print(cMNode.firstPos().toString());
            System.out.print(" lastPos=");
            System.out.println(cMNode.lastPos().toString());
        } else {
            throw new CMException(10);
        }
    }

    private int[] makeDefStateList() {
        int[] nArray = new int[this.fElemMapSize];
        int n = 0;
        while (n < this.fElemMapSize) {
            nArray[n] = -1;
            ++n;
        }
        return nArray;
    }

    private int postTreeBuildInit(CMNode cMNode, int n) throws CMException {
        cMNode.setMaxStates(this.fLeafCount);
        if ((cMNode.type() & 0xF) == 6 || (cMNode.type() & 0xF) == 8 || (cMNode.type() & 0xF) == 7) {
            QName qName = new QName(-1, -1, -1, ((CMAny)cMNode).getURI());
            this.fLeafList[n] = new CMLeaf(qName, ((CMAny)cMNode).getPosition());
            this.fLeafListType[n] = cMNode.type();
            ++n;
        } else if (cMNode.type() == 4 || cMNode.type() == 5) {
            n = this.postTreeBuildInit(((CMBinOp)cMNode).getLeft(), n);
            n = this.postTreeBuildInit(((CMBinOp)cMNode).getRight(), n);
        } else if (cMNode.type() == 2) {
            n = this.postTreeBuildInit(((CMUniOp)cMNode).getChild(), n);
        } else if (cMNode.type() == 0) {
            QName qName = ((CMLeaf)cMNode).getElement();
            if (qName.localpart != this.fEpsilonIndex) {
                this.fLeafList[n] = (CMLeaf)cMNode;
                this.fLeafListType[n] = 0;
                ++n;
            }
        } else {
            throw new CMException(10);
        }
        return n;
    }
}

