/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.IOException;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.apache.xmlrpc.XmlRpcException;

public class TestBase64
implements Runnable {
    static String url;
    static int clients;
    static int loops;
    XmlRpcClient client = new XmlRpcClientLite(url);
    int gCalls = 0;
    int gErrors = 0;
    byte[] data;

    public void run() {
        int n;
        int n2 = 0;
        int n3 = 0;
        long l = System.currentTimeMillis();
        try {
            n = (int)(-100.0 * Math.random());
            Vector<byte[]> vector = new Vector<byte[]>();
            vector.addElement(this.data);
            int n4 = 0;
            while (n4 < loops) {
                Vector vector2 = (Vector)this.client.execute("echo", vector);
                byte[] byArray = (byte[])vector2.elementAt(0);
                int n5 = 0;
                while (n5 < byArray.length) {
                    if (byArray[n5] != (byte)n5) {
                        ++n2;
                    }
                    ++n5;
                }
                ++n3;
                ++n4;
            }
        }
        catch (IOException iOException) {
            System.err.println("Exception in client: " + iOException);
            iOException.printStackTrace();
        }
        catch (XmlRpcException xmlRpcException) {
            System.err.println("Server reported error: " + xmlRpcException);
        }
        catch (Exception exception) {
            System.err.println("Exception in Benchmark client: " + exception);
        }
        n = (int)(System.currentTimeMillis() - l);
        this.checkout(n3, n2, n);
    }

    private synchronized void checkout(int n, int n2, int n3) {
        this.gCalls += n;
        this.gErrors += n2;
        System.err.println("Benchmark thread finished: " + n + " calls, " + n2 + " errors in " + n3 + " milliseconds.");
        if (--clients == 0) {
            System.err.println("");
            System.err.println("Benchmark result: " + 1000 * this.gCalls / n3 + " calls per second.");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0 && stringArray.length < 3) {
            url = stringArray[0];
            XmlRpc.setKeepAlive(true);
            if (stringArray.length == 2) {
                XmlRpc.setDriver(stringArray[1]);
            }
            new TestBase64();
        } else {
            System.err.println("Usage: java org.apache.xmlrpc.Benchmark URL [SAXDriver]");
        }
    }

    public TestBase64() throws Exception {
        Vector<Integer> vector = new Vector<Integer>();
        vector.addElement(new Integer(123));
        this.client.execute("math.abs", vector);
        this.data = new byte[20000];
        int n = 0;
        while (n < this.data.length) {
            this.data[n] = (byte)n;
            ++n;
        }
        n = 0;
        while (n < clients) {
            new Thread(this).start();
            ++n;
        }
    }

    static {
        clients = 1;
        loops = 1;
    }
}

