/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;

class Invoker
implements XmlRpcHandler {
    private Object invokeTarget;
    private Class targetClass;

    public Object execute(String string, Vector vector) throws Exception {
        Class[] classArray = null;
        Object[] objectArray = null;
        if (vector != null) {
            classArray = new Class[vector.size()];
            objectArray = new Object[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                objectArray[n] = vector.elementAt(n);
                classArray[n] = objectArray[n] instanceof Integer ? Integer.TYPE : (objectArray[n] instanceof Double ? Double.TYPE : (objectArray[n] instanceof Boolean ? Boolean.TYPE : objectArray[n].getClass()));
                ++n;
            }
        }
        Method method = null;
        if (XmlRpc.debug) {
            System.err.println("Searching for method: " + string);
            int n = 0;
            while (n < classArray.length) {
                System.err.println("Parameter " + n + ": " + classArray[n] + " = " + objectArray[n]);
                ++n;
            }
        }
        try {
            method = this.targetClass.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw noSuchMethodException;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        if (method.getDeclaringClass() == Class.forName("java.lang.Object")) {
            throw new XmlRpcException(0, "Invoker can't call methods defined in java.lang.Object");
        }
        Object object = null;
        try {
            object = method.invoke(this.invokeTarget, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw illegalAccessException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable;
            if (XmlRpc.debug) {
                invocationTargetException.getTargetException().printStackTrace();
            }
            if ((throwable = invocationTargetException.getTargetException()) instanceof XmlRpcException) {
                throw (XmlRpcException)throwable;
            }
            throw new Exception(throwable.toString());
        }
        return object;
    }

    public Invoker(Object object) {
        this.invokeTarget = object;
        Class<?> clazz = this.targetClass = this.invokeTarget instanceof Class ? (Class<?>)this.invokeTarget : this.invokeTarget.getClass();
        if (XmlRpc.debug) {
            System.err.println("Target object is " + this.targetClass);
        }
    }
}

