/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.ref.DTMNodeIterator;
import org.apache.xml.dtm.ref.DTMNodeList;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.objects.Comparator;
import org.apache.xpath.objects.EqualComparator;
import org.apache.xpath.objects.GreaterThanComparator;
import org.apache.xpath.objects.GreaterThanOrEqualComparator;
import org.apache.xpath.objects.LessThanComparator;
import org.apache.xpath.objects.LessThanOrEqualComparator;
import org.apache.xpath.objects.NotEqualComparator;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XNodeSet
extends XObject {
    protected DTMManager m_dtmMgr;
    static LessThanComparator S_LT = new LessThanComparator();
    static LessThanOrEqualComparator S_LTE = new LessThanOrEqualComparator();
    static GreaterThanComparator S_GT = new GreaterThanComparator();
    static GreaterThanOrEqualComparator S_GTE = new GreaterThanOrEqualComparator();
    static EqualComparator S_EQ = new EqualComparator();
    static NotEqualComparator S_NEQ = new NotEqualComparator();

    protected XNodeSet() {
    }

    public XNodeSet(int n, DTMManager dtmMgr) {
        super(new NodeSetDTM(dtmMgr));
        this.m_dtmMgr = dtmMgr;
        if (n != -1) {
            ((NodeSetDTM)this.m_obj).addNode(n);
        }
    }

    public XNodeSet(DTMIterator val) {
        super(val);
        this.m_dtmMgr = val.getDTMManager();
    }

    public XNodeSet(DTMManager dtmMgr) {
        super(new NodeSetDTM(dtmMgr));
        this.m_dtmMgr = dtmMgr;
    }

    public void allowDetachToRelease(boolean allowRelease) {
        if (this.m_obj != null) {
            ((DTMIterator)this.m_obj).allowDetachToRelease(allowRelease);
        }
    }

    public void appendToFsb(FastStringBuffer fsb) {
        XString xstring = (XString)this.xstr();
        xstring.appendToFsb(fsb);
    }

    public boolean bool() {
        return this.iter().nextNode() != -1;
    }

    public boolean boolWithSideEffects() {
        return this.iterRaw().nextNode() != -1;
    }

    public boolean compare(XObject obj2, Comparator comparator) throws TransformerException {
        boolean result = false;
        int type = obj2.getType();
        if (type == 4) {
            int node1;
            DTMIterator list1 = this.iter();
            DTMIterator list2 = ((XNodeSet)obj2).iter();
            Vector<XMLString> node2Strings = null;
            block0: while ((node1 = list1.nextNode()) != -1) {
                XMLString s1 = this.getStringFromNode(node1);
                if (node2Strings == null) {
                    int node2;
                    while ((node2 = list2.nextNode()) != -1) {
                        XMLString s2 = this.getStringFromNode(node2);
                        if (comparator.compareStrings(s1, s2)) {
                            result = true;
                            continue block0;
                        }
                        if (node2Strings == null) {
                            node2Strings = new Vector<XMLString>();
                        }
                        node2Strings.addElement(s2);
                    }
                    continue;
                }
                int n = node2Strings.size();
                int i = 0;
                while (i < n) {
                    if (comparator.compareStrings(s1, (XMLString)node2Strings.elementAt(i))) {
                        result = true;
                        continue block0;
                    }
                    ++i;
                }
            }
        } else if (type == 1) {
            double num1 = this.bool() ? 1.0 : 0.0;
            double num2 = obj2.num();
            result = comparator.compareNumbers(num1, num2);
        } else if (type == 2) {
            int node;
            DTMIterator list1 = this.iter();
            double num2 = obj2.num();
            while ((node = list1.nextNode()) != -1) {
                double num1 = this.getNumberFromNode(node);
                if (!comparator.compareNumbers(num1, num2)) continue;
                result = true;
                break;
            }
        } else if (type == 5) {
            int node;
            XMLString s2 = obj2.xstr();
            DTMIterator list1 = this.iter();
            while ((node = list1.nextNode()) != -1) {
                XMLString s1 = this.getStringFromNode(node);
                if (!comparator.compareStrings(s1, s2)) continue;
                result = true;
                break;
            }
        } else if (type == 3) {
            int node;
            XMLString s2 = obj2.xstr();
            DTMIterator list1 = this.iter();
            while ((node = list1.nextNode()) != -1) {
                XMLString s1 = this.getStringFromNode(node);
                if (!comparator.compareStrings(s1, s2)) continue;
                result = true;
                break;
            }
        } else {
            result = comparator.compareNumbers(this.num(), obj2.num());
        }
        return result;
    }

    public void detach() {
        if (this.m_obj != null) {
            Object obj = this.m_obj;
            this.m_obj = null;
            ((DTMIterator)obj).detach();
        }
    }

    public void dispatchCharactersEvents(ContentHandler ch) throws SAXException {
        DTMIterator nl = this.iter();
        int node = nl.nextNode();
        if (node != -1) {
            this.m_dtmMgr.getDTM(node).dispatchCharactersEvents(node, ch, false);
        }
    }

    public boolean equals(XObject obj2) {
        try {
            return this.compare(obj2, S_EQ);
        }
        catch (TransformerException te) {
            throw new WrappedRuntimeException(te);
        }
    }

    public DTMManager getDTMMgr() {
        return this.m_dtmMgr;
    }

    public double getNumberFromNode(int n) {
        XMLString xstr = this.m_dtmMgr.getDTM(n).getStringValue(n);
        return xstr.toDouble();
    }

    public XMLString getStringFromNode(int n) {
        if (n != -1) {
            return this.m_dtmMgr.getDTM(n).getStringValue(n);
        }
        return XString.EMPTYSTRING;
    }

    public int getType() {
        return 4;
    }

    public String getTypeString() {
        return "#NODESET";
    }

    public boolean greaterThan(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_GT);
    }

    public boolean greaterThanOrEqual(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_GTE);
    }

    public DTMIterator iter() {
        try {
            return ((DTMIterator)this.m_obj).cloneWithReset();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse.getMessage());
        }
    }

    public DTMIterator iterRaw() {
        return (DTMIterator)this.m_obj;
    }

    public boolean lessThan(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_LT);
    }

    public boolean lessThanOrEqual(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_LTE);
    }

    public NodeSetDTM mutableNodeset() {
        NodeSetDTM mnl;
        if (this.m_obj instanceof NodeSetDTM) {
            mnl = (NodeSetDTM)this.m_obj;
        } else {
            mnl = new NodeSetDTM(this.iter());
            this.m_obj = mnl;
        }
        return mnl;
    }

    public NodeList nodelist() throws TransformerException {
        return new DTMNodeList(this.iter());
    }

    public NodeIterator nodeset() throws TransformerException {
        return new DTMNodeIterator(this.iter());
    }

    public boolean notEquals(XObject obj2) throws TransformerException {
        return this.compare(obj2, S_NEQ);
    }

    public double num() {
        DTMIterator nl = this.iter();
        int node = nl.nextNode();
        return node != -1 ? this.getNumberFromNode(node) : Double.NaN;
    }

    public double numWithSideEffects() {
        DTMIterator nl = this.iterRaw();
        int node = nl.nextNode();
        return node != -1 ? this.getNumberFromNode(node) : Double.NaN;
    }

    public String str() {
        DTMIterator nl = this.iter();
        int node = nl.nextNode();
        return node != -1 ? this.getStringFromNode(node).toString() : "";
    }

    public XMLString xstr() {
        DTMIterator nl = this.iter();
        int node = nl.nextNode();
        return node != -1 ? this.getStringFromNode(node) : XString.EMPTYSTRING;
    }
}

