/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.StringVector;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.XPathContext;
import org.apache.xpath.functions.FunctionOneArg;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;

public class FuncId
extends FunctionOneArg {
    public XObject execute(XPathContext xctxt) throws TransformerException {
        int context = xctxt.getCurrentNode();
        DTM dtm = xctxt.getDTM(context);
        int docContext = dtm.getDocument();
        if (docContext == -1) {
            this.error(xctxt, 4, null);
        }
        XObject arg = this.m_arg0.execute(xctxt);
        int argType = arg.getType();
        XNodeSet nodes = new XNodeSet(xctxt.getDTMManager());
        NodeSetDTM nodeSet = nodes.mutableNodeset();
        if (argType == 4) {
            DTMIterator ni = arg.iter();
            StringVector usedrefs = null;
            int pos = ni.nextNode();
            while (pos != -1) {
                DTM ndtm = ni.getDTM(pos);
                String refval = ndtm.getStringValue(pos).toString();
                pos = ni.nextNode();
                usedrefs = this.getNodesByID(xctxt, docContext, refval, usedrefs, nodeSet, pos != -1);
            }
        } else {
            if (argType == -1) {
                return nodes;
            }
            String refval = arg.str();
            this.getNodesByID(xctxt, docContext, refval, null, nodeSet, false);
        }
        return nodes;
    }

    private StringVector getNodesByID(XPathContext xctxt, int docContext, String refval, StringVector usedrefs, NodeSetDTM nodeSet, boolean mayBeMore) {
        if (refval != null) {
            String ref = null;
            StringTokenizer tokenizer = new StringTokenizer(refval);
            boolean hasMore = tokenizer.hasMoreTokens();
            DTM dtm = xctxt.getDTM(docContext);
            while (hasMore) {
                ref = tokenizer.nextToken();
                hasMore = tokenizer.hasMoreTokens();
                if (usedrefs != null && usedrefs.contains(ref)) {
                    ref = null;
                    continue;
                }
                int node = dtm.getElementById(ref);
                if (node != -1) {
                    nodeSet.addNodeInDocOrder(node, xctxt);
                }
                if (ref == null || !hasMore && !mayBeMore) continue;
                if (usedrefs == null) {
                    usedrefs = new StringVector();
                }
                usedrefs.addElement(ref);
            }
        }
        return usedrefs;
    }
}

