/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.VariableStack;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;

public class WalkingIterator
extends LocPathIterator {
    protected AxesWalker m_lastUsedWalker;
    protected AxesWalker m_firstWalker;

    protected WalkingIterator(PrefixResolver nscontext) {
        super(nscontext);
    }

    WalkingIterator(Compiler compiler, int opPos, int analysis, boolean shouldLoadWalkers) throws TransformerException {
        super(compiler, opPos, analysis, shouldLoadWalkers);
        int firstStepPos = OpMap.getFirstChildPos(opPos);
        if (shouldLoadWalkers) {
            this.m_lastUsedWalker = this.m_firstWalker = WalkerFactory.loadWalkers(this, compiler, firstStepPos, 0);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        WalkingIterator clone = (WalkingIterator)super.clone();
        if (this.m_firstWalker != null) {
            clone.m_firstWalker = this.m_firstWalker.cloneDeep(clone, null);
        }
        return clone;
    }

    public void detach() {
        this.m_lastUsedWalker = null;
        super.detach();
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        this.m_predicateIndex = -1;
        AxesWalker walker = this.m_firstWalker;
        while (walker != null) {
            walker.fixupVariables(vars, globalsSize);
            walker = walker.getNextWalker();
        }
    }

    public final AxesWalker getFirstWalker() {
        return this.m_firstWalker;
    }

    public final AxesWalker getLastUsedWalker() {
        return this.m_lastUsedWalker;
    }

    public int nextNode() {
        if (this.m_cachedNodes != null) {
            if (this.m_next < this.m_cachedNodes.size()) {
                this.m_lastFetched = this.m_currentContextNode = this.m_cachedNodes.elementAt(this.m_next);
                int next = this.m_currentContextNode;
                this.incrementNextPosition();
                return next;
            }
            if (this.m_foundLast) {
                this.m_lastFetched = -1;
                return -1;
            }
        }
        if (this.m_stackFrame == -1) {
            if (this.m_firstWalker.getRoot() == -1) {
                this.setNextPosition(0);
                this.m_firstWalker.setRoot(this.m_context);
                this.m_lastUsedWalker = this.m_firstWalker;
            }
            return this.returnNextNode(this.m_firstWalker.nextNode());
        }
        VariableStack vars = this.m_execContext.getVarStack();
        int savedStart = vars.getStackFrame();
        vars.setStackFrame(this.m_stackFrame);
        if (this.m_firstWalker.getRoot() == -1) {
            this.setNextPosition(0);
            this.m_firstWalker.setRoot(this.m_context);
            this.m_lastUsedWalker = this.m_firstWalker;
        }
        int n = this.returnNextNode(this.m_firstWalker.nextNode());
        vars.setStackFrame(savedStart);
        return n;
    }

    public void reset() {
        super.reset();
        if (this.m_firstWalker != null) {
            this.m_lastUsedWalker = this.m_firstWalker;
            this.m_firstWalker.setRoot(this.m_context);
        }
    }

    public final void setLastUsedWalker(AxesWalker walker) {
        this.m_lastUsedWalker = walker;
    }
}

