/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;

public abstract class PredicatedNodeTest
extends NodeTest
implements SubContextList {
    protected transient boolean m_foundLast = false;
    protected LocPathIterator m_lpi;
    transient int m_predicateIndex = -1;
    private Expression[] m_predicates;
    protected transient int[] m_proximityPositions;
    static final boolean DEBUG_PREDICATECOUNTING = false;

    PredicatedNodeTest() {
    }

    PredicatedNodeTest(LocPathIterator locPathIterator) {
        this.m_lpi = locPathIterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short acceptNode(int n) {
        XPathContext xctxt;
        block6: {
            short s;
            xctxt = this.m_lpi.getXPathContext();
            try {
                try {
                    xctxt.pushCurrentNode(n);
                    XObject score = this.execute(xctxt, n);
                    if (score == NodeTest.SCORE_NONE) break block6;
                    if (this.getPredicateCount() > 0) {
                        this.countProximityPosition(0);
                        if (!this.executePredicates(n, xctxt)) {
                            short s2 = 3;
                            Object var5_7 = null;
                            xctxt.popCurrentNode();
                            return s2;
                        }
                    }
                    s = 1;
                }
                catch (TransformerException se) {
                    throw new RuntimeException(se.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                xctxt.popCurrentNode();
                throw throwable;
            }
            Object var5_8 = null;
            xctxt.popCurrentNode();
            return s;
        }
        Object var5_9 = null;
        xctxt.popCurrentNode();
        return 3;
    }

    public boolean canTraverseOutsideSubtree() {
        int n = this.getPredicateCount();
        int i = 0;
        while (i < n) {
            if (this.getPredicate(i).canTraverseOutsideSubtree()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        PredicatedNodeTest clone = (PredicatedNodeTest)super.clone();
        if (this.m_proximityPositions != null && this.m_proximityPositions == clone.m_proximityPositions) {
            clone.m_proximityPositions = new int[this.m_proximityPositions.length];
            System.arraycopy(this.m_proximityPositions, 0, clone.m_proximityPositions, 0, this.m_proximityPositions.length);
        }
        if (clone.m_lpi == this) {
            clone.m_lpi = (LocPathIterator)clone;
        }
        return clone;
    }

    protected void countProximityPosition(int i) {
        if (i < this.m_proximityPositions.length) {
            int n = i;
            this.m_proximityPositions[n] = this.m_proximityPositions[n] + 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean executePredicates(int context, XPathContext xctxt) throws TransformerException {
        block10: {
            boolean bl;
            block9: {
                int nPredicates = this.getPredicateCount();
                if (nPredicates == 0) {
                    return true;
                }
                PrefixResolver savedResolver = xctxt.getNamespaceContext();
                try {
                    this.m_predicateIndex = 0;
                    xctxt.pushSubContextList(this);
                    xctxt.pushNamespaceContext(this.m_lpi.getPrefixResolver());
                    xctxt.pushCurrentNode(context);
                    int i = 0;
                    while (i < nPredicates) {
                        XObject pred = this.m_predicates[i].execute(xctxt);
                        if (pred.getType() == 2) {
                            int proxPos = this.getProximityPosition(this.m_predicateIndex);
                            if (proxPos != (int)pred.num()) {
                                boolean bl2 = false;
                                Object var7_10 = null;
                                xctxt.popCurrentNode();
                                xctxt.popNamespaceContext();
                                xctxt.popSubContextList();
                                this.m_predicateIndex = -1;
                                return bl2;
                            }
                            if (this.m_predicates[i].isStableNumber()) {
                                this.m_foundLast = true;
                            }
                        } else if (!pred.bool()) {
                            bl = false;
                            break block9;
                        }
                        this.countProximityPosition(++this.m_predicateIndex);
                        ++i;
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var7_13 = null;
                    xctxt.popCurrentNode();
                    xctxt.popNamespaceContext();
                    xctxt.popSubContextList();
                    this.m_predicateIndex = -1;
                    throw throwable;
                }
            }
            Object var7_11 = null;
            xctxt.popCurrentNode();
            xctxt.popNamespaceContext();
            xctxt.popSubContextList();
            this.m_predicateIndex = -1;
            return bl;
        }
        Object var7_12 = null;
        xctxt.popCurrentNode();
        xctxt.popNamespaceContext();
        xctxt.popSubContextList();
        this.m_predicateIndex = -1;
        return true;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        super.fixupVariables(vars, globalsSize);
        int nPredicates = this.getPredicateCount();
        int i = 0;
        while (i < nPredicates) {
            this.m_predicates[i].fixupVariables(vars, globalsSize);
            ++i;
        }
    }

    public abstract int getLastPos(XPathContext var1);

    public LocPathIterator getLocPathIterator() {
        return this.m_lpi;
    }

    Expression getPredicate(int index) {
        return this.m_predicates[index];
    }

    public int getPredicateCount() {
        return this.m_predicates == null ? 0 : this.m_predicates.length;
    }

    public int getPredicateIndex() {
        return this.m_predicateIndex;
    }

    public int getProximityPosition() {
        return this.getProximityPosition(this.m_predicateIndex);
    }

    protected int getProximityPosition(int predicateIndex) {
        return predicateIndex >= 0 ? this.m_proximityPositions[predicateIndex] : 0;
    }

    public int getProximityPosition(XPathContext xctxt) {
        return this.getProximityPosition();
    }

    protected void initPredicateInfo(Compiler compiler, int opPos) throws TransformerException {
        int pos = compiler.getFirstPredicateOpPos(opPos);
        if (pos > 0) {
            this.m_predicates = compiler.getCompiledPredicates(pos);
        }
    }

    public void initProximityPosition(int i) throws TransformerException {
        this.m_proximityPositions[i] = 0;
    }

    public boolean isReverseAxes() {
        return false;
    }

    protected String nodeToString(int n) {
        if (n != -1) {
            DTM dtm = this.m_lpi.getXPathContext().getDTM(n);
            return String.valueOf(dtm.getNodeName(n)) + "{" + (n + 1) + "}";
        }
        return "null";
    }

    private void readObject(ObjectInputStream stream) throws IOException, TransformerException {
        try {
            stream.defaultReadObject();
            this.m_predicateIndex = -1;
            this.resetProximityPositions();
        }
        catch (ClassNotFoundException cnfe) {
            throw new TransformerException(cnfe);
        }
    }

    public void resetProximityPositions() {
        int nPredicates = this.getPredicateCount();
        if (nPredicates > 0) {
            if (this.m_proximityPositions == null) {
                this.m_proximityPositions = new int[nPredicates];
            }
            int i = 0;
            while (i < nPredicates) {
                try {
                    this.initProximityPosition(i);
                }
                catch (Exception e) {
                    throw new WrappedRuntimeException(e);
                }
                ++i;
            }
        }
    }

    public void setLocPathIterator(LocPathIterator li) {
        this.m_lpi = li;
    }

    public void setPredicateCount(int count) {
        if (count > 0) {
            Expression[] newPredicates = new Expression[count];
            int i = 0;
            while (i < count) {
                newPredicates[i] = this.m_predicates[i];
                ++i;
            }
            this.m_predicates = newPredicates;
        } else {
            this.m_predicates = null;
        }
    }
}

