/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;

public final class VariableStack
implements Cloneable {
    XObject[] _sf = new XObject[8192];
    int _top;
    private int _cfb;
    int[] _links = new int[4096];
    int _linksTop;
    private static XObject[] m_nulls = new XObject[1024];

    public VariableStack() {
        this.reset();
    }

    public final void clearLocalSlots(int start, int len) {
        System.arraycopy(m_nulls, 0, this._sf, start += this._cfb, len);
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        VariableStack vs = (VariableStack)super.clone();
        vs._sf = (XObject[])this._sf.clone();
        vs._links = (int[])this._links.clone();
        return vs;
    }

    public final XObject elementAt(int i) {
        return this._sf[i];
    }

    public final XObject getGlobalVariable(XPathContext xctxt, int index) throws TransformerException {
        XObject val = this._sf[index];
        if (val.getType() == 600) {
            this._sf[index] = val.execute(xctxt);
            return this._sf[index];
        }
        return val;
    }

    public final XObject getLocalVariable(int index, int frame) throws TransformerException {
        XObject val = this._sf[index += frame];
        return val;
    }

    public final XObject getLocalVariable(XPathContext xctxt, int index) throws TransformerException {
        XObject val = this._sf[index += this._cfb];
        if (val == null) {
            throw new TransformerException("Variable accessed before it is bound!", xctxt.getSAXLocator());
        }
        if (val.getType() == 600) {
            this._sf[index] = val.execute(xctxt);
            return this._sf[index];
        }
        return val;
    }

    public final int getStackFrame() {
        return this._cfb;
    }

    public final XObject getVariableOrParam(XPathContext xctxt, QName qname) throws TransformerException {
        PrefixResolver prefixResolver = xctxt.getNamespaceContext();
        if (prefixResolver instanceof ElemTemplateElement) {
            ElemVariable vvar;
            ElemTemplateElement prev = (ElemTemplateElement)prefixResolver;
            if (!(prev instanceof Stylesheet)) {
                while (!(prev.getParentNode() instanceof Stylesheet)) {
                    ElemTemplateElement savedprev = prev;
                    while ((prev = prev.getPreviousSiblingElem()) != null) {
                        if (!(prev instanceof ElemVariable) || !(vvar = (ElemVariable)prev).getName().equals(qname)) continue;
                        return this.getLocalVariable(xctxt, vvar.getIndex());
                    }
                    prev = savedprev.getParentElem();
                }
            }
            if ((vvar = prev.getStylesheetRoot().getVariableOrParamComposed(qname)) != null) {
                return this.getGlobalVariable(xctxt, vvar.getIndex());
            }
        }
        throw new TransformerException(XSLMessages.createXPATHMessage(74, new Object[]{qname.toString()}));
    }

    public final boolean isLocalSet(int index) throws TransformerException {
        return this._sf[index + this._cfb] != null;
    }

    public final int link(int size) {
        this._cfb = this._top;
        this._top += size;
        if (this._top >= this._sf.length) {
            XObject[] newsf = new XObject[this._sf.length + 4096 + size];
            System.arraycopy(this._sf, 0, newsf, 0, this._sf.length);
            this._sf = newsf;
        }
        if (this._linksTop + 1 >= this._links.length) {
            int[] newlinks = new int[this._links.length + 2048];
            System.arraycopy(this._links, 0, newlinks, 0, this._links.length);
            this._links = newlinks;
        }
        this._links[this._linksTop++] = this._cfb;
        return this._cfb;
    }

    public final void reset() {
        this._top = 0;
        this._linksTop = 0;
        this._links[this._linksTop++] = 0;
    }

    public final void setGlobalVariable(int index, XObject val) {
        this._sf[index] = val;
    }

    public final void setLocalVariable(int index, XObject val) {
        this._sf[index + this._cfb] = val;
    }

    public final void setLocalVariable(int index, XObject val, int stackFrame) {
        this._sf[index + stackFrame] = val;
    }

    public final void setStackFrame(int sf) {
        this._cfb = sf;
    }

    public final int size() {
        return this._top;
    }

    public final void unlink() {
        this._top = this._links[--this._linksTop];
        this._cfb = this._links[this._linksTop - 1];
    }
}

