/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.utils.WrappedRuntimeException;

public abstract class DTMAxisIteratorBase
implements DTMAxisIterator {
    private int _last = -1;
    private int _position = 0;
    protected int _markedNode;
    protected int _startNode = -1;
    protected boolean _includeSelf = false;
    protected boolean _isRestartable = true;

    public DTMAxisIterator cloneIterator() {
        try {
            DTMAxisIteratorBase clone = (DTMAxisIteratorBase)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public int getAxis() {
        return -1;
    }

    public int getLast() {
        if (this._last == -1) {
            int temp = this._position;
            this.setMark();
            this.reset();
            do {
                ++this._last;
            } while (this.next() != -1);
            this.gotoMark();
            this._position = temp;
        }
        return this._last;
    }

    public int getPosition() {
        return this._position == 0 ? 1 : this._position;
    }

    public int getStartNode() {
        return this._startNode;
    }

    public abstract void gotoMark();

    public DTMAxisIterator includeSelf() {
        this._includeSelf = true;
        return this;
    }

    public boolean isDocOrdered() {
        return true;
    }

    public boolean isReverse() {
        return false;
    }

    public abstract int next();

    public DTMAxisIterator reset() {
        boolean temp = this._isRestartable;
        this._isRestartable = true;
        this.setStartNode(this._startNode);
        this._isRestartable = temp;
        return this;
    }

    protected final DTMAxisIterator resetPosition() {
        this._position = 0;
        return this;
    }

    protected final int returnNode(int node) {
        ++this._position;
        return node;
    }

    public abstract void setMark();

    public abstract DTMAxisIterator setStartNode(int var1);
}

