/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.lib.sql.ConnectionPool;
import org.apache.xalan.lib.sql.ConnectionPoolManager;
import org.apache.xalan.lib.sql.DefaultConnectionPool;
import org.apache.xalan.lib.sql.QueryParameter;
import org.apache.xalan.lib.sql.SQLDocument;
import org.apache.xalan.lib.sql.SQLErrorDocument;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.ref.DTMManagerDefault;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XBooleanStatic;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XConnection {
    private static final boolean DEBUG = false;
    private ConnectionPool m_ConnectionPool = null;
    private boolean m_DefaultPoolingEnabled = false;
    private Vector m_OpenSQLDocuments = new Vector();
    private ConnectionPoolManager m_PoolMgr = new ConnectionPoolManager();
    private Vector m_ParameterList = new Vector();
    private SQLErrorDocument m_Error = null;
    private boolean m_IsDefaultPool = false;
    private boolean m_IsStreamingEnabled = true;

    public XConnection() {
    }

    public XConnection(ExpressionContext exprContext, String ConnPoolName) {
        this.connect(exprContext, ConnPoolName);
    }

    public XConnection(ExpressionContext exprContext, String driver, String dbURL) {
        this.connect(exprContext, driver, dbURL);
    }

    public XConnection(ExpressionContext exprContext, String driver, String dbURL, String user, String password) {
        this.connect(exprContext, driver, dbURL, user, password);
    }

    public XConnection(ExpressionContext exprContext, String driver, String dbURL, Element protocolElem) {
        this.connect(exprContext, driver, dbURL, protocolElem);
    }

    public XConnection(ExpressionContext exprContext, NodeList list) {
        this.connect(exprContext, list);
    }

    public void addParameter(String value) {
        this.addParameterWithType(value, null);
    }

    public void addParameterFromElement(Element e) {
        NamedNodeMap attrs = e.getAttributes();
        Node Type2 = attrs.getNamedItem("type");
        Node n1 = e.getFirstChild();
        if (n1 != null) {
            String value = n1.getNodeValue();
            if (value == null) {
                value = "";
            }
            this.m_ParameterList.addElement(new QueryParameter(value, Type2.getNodeValue()));
        }
    }

    public void addParameterFromElement(NodeList nl) {
        int count = nl.getLength();
        int x = 0;
        while (x < count) {
            this.addParameters((Element)nl.item(x));
            ++x;
        }
    }

    public void addParameterWithType(String value, String Type2) {
        this.m_ParameterList.addElement(new QueryParameter(value, Type2));
    }

    private void addParameters(Element elem) {
        Node n = elem.getFirstChild();
        if (n == null) {
            return;
        }
        do {
            if (n.getNodeType() != 1) continue;
            NamedNodeMap attrs = n.getAttributes();
            Node Type2 = attrs.getNamedItem("type");
            String TypeStr = Type2 == null ? "string" : Type2.getNodeValue();
            Node n1 = n.getFirstChild();
            if (n1 == null) continue;
            String value = n1.getNodeValue();
            if (value == null) {
                value = "";
            }
            this.m_ParameterList.addElement(new QueryParameter(value, TypeStr));
        } while ((n = n.getNextSibling()) != null);
    }

    private void buildErrorDocument(ExpressionContext exprContext, Exception excp) {
        try {
            DTMManager mgr = ((XPathContext.XPathExpressionContext)exprContext).getDTMManager();
            DTMManagerDefault mgrDefault = (DTMManagerDefault)mgr;
            int dtmIdent = mgrDefault.getFirstFreeDTMID();
            this.m_Error = new SQLErrorDocument(mgr, dtmIdent << 22, excp);
            mgrDefault.addDTM(this.m_Error, dtmIdent);
        }
        catch (Exception exception) {
            this.m_Error = null;
        }
    }

    private void buildErrorDocument(ExpressionContext exprContext, SQLException excp) {
        try {
            DTMManager mgr = ((XPathContext.XPathExpressionContext)exprContext).getDTMManager();
            DTMManagerDefault mgrDefault = (DTMManagerDefault)mgr;
            int dtmIdent = mgrDefault.getFirstFreeDTMID();
            this.m_Error = new SQLErrorDocument(mgr, dtmIdent << 22, excp);
            mgrDefault.addDTM(this.m_Error, dtmIdent);
        }
        catch (Exception exception) {
            this.m_Error = null;
        }
    }

    public void clearParameters() {
        this.m_ParameterList.removeAllElements();
    }

    public void close() throws SQLException {
        while (this.m_OpenSQLDocuments.size() != 0) {
            SQLDocument d = (SQLDocument)this.m_OpenSQLDocuments.elementAt(0);
            d.close();
            this.m_OpenSQLDocuments.removeElementAt(0);
        }
    }

    public void close(SQLDocument sqldoc) throws SQLException {
        int size = this.m_OpenSQLDocuments.size();
        int x = 0;
        while (x < size) {
            SQLDocument d = (SQLDocument)this.m_OpenSQLDocuments.elementAt(x);
            if (d == sqldoc) {
                d.close();
                this.m_OpenSQLDocuments.removeElementAt(x);
            }
            ++x;
        }
    }

    public XBooleanStatic connect(ExpressionContext exprContext, String ConnPoolName) {
        try {
            this.m_ConnectionPool = this.m_PoolMgr.getPool(ConnPoolName);
            if (this.m_ConnectionPool == null) {
                throw new IllegalArgumentException("Invalid Pool Name");
            }
            this.m_IsDefaultPool = false;
            return new XBooleanStatic(true);
        }
        catch (Exception e) {
            this.buildErrorDocument(exprContext, e);
            return new XBooleanStatic(false);
        }
    }

    public XBooleanStatic connect(ExpressionContext exprContext, String driver, String dbURL) {
        try {
            this.init(driver, dbURL, new Properties());
            return new XBooleanStatic(true);
        }
        catch (SQLException e) {
            this.buildErrorDocument(exprContext, e);
            return new XBooleanStatic(false);
        }
        catch (Exception e) {
            this.buildErrorDocument(exprContext, e);
            return new XBooleanStatic(false);
        }
    }

    public XBooleanStatic connect(ExpressionContext exprContext, String driver, String dbURL, String user, String password) {
        try {
            Properties prop = new Properties();
            ((Hashtable)prop).put("user", user);
            ((Hashtable)prop).put("password", password);
            this.init(driver, dbURL, prop);
            return new XBooleanStatic(true);
        }
        catch (SQLException e) {
            this.buildErrorDocument(exprContext, e);
            return new XBooleanStatic(false);
        }
        catch (Exception e) {
            this.buildErrorDocument(exprContext, e);
            return new XBooleanStatic(false);
        }
    }

    public XBooleanStatic connect(ExpressionContext exprContext, String driver, String dbURL, Element protocolElem) {
        try {
            Properties prop = new Properties();
            NamedNodeMap atts = protocolElem.getAttributes();
            int i = 0;
            while (i < atts.getLength()) {
                ((Hashtable)prop).put(atts.item(i).getNodeName(), atts.item(i).getNodeValue());
                ++i;
            }
            this.init(driver, dbURL, prop);
            return new XBooleanStatic(true);
        }
        catch (SQLException e) {
            this.buildErrorDocument(exprContext, e);
            return new XBooleanStatic(false);
        }
        catch (Exception e) {
            this.buildErrorDocument(exprContext, e);
            return new XBooleanStatic(false);
        }
    }

    public XBooleanStatic connect(ExpressionContext exprContext, Element protocolElem) {
        try {
            this.initFromElement(protocolElem);
            return new XBooleanStatic(true);
        }
        catch (SQLException e) {
            this.buildErrorDocument(exprContext, e);
            return new XBooleanStatic(false);
        }
        catch (Exception e) {
            this.buildErrorDocument(exprContext, e);
            return new XBooleanStatic(false);
        }
    }

    public XBooleanStatic connect(ExpressionContext exprContext, NodeList list) {
        try {
            this.initFromElement((Element)list.item(0));
            return new XBooleanStatic(true);
        }
        catch (SQLException e) {
            this.buildErrorDocument(exprContext, e);
            return new XBooleanStatic(false);
        }
        catch (Exception e) {
            this.buildErrorDocument(exprContext, e);
            return new XBooleanStatic(false);
        }
    }

    public void disableDefaultConnectionPool() {
        this.m_DefaultPoolingEnabled = false;
        if (this.m_ConnectionPool == null) {
            return;
        }
        if (!this.m_IsDefaultPool) {
            return;
        }
        this.m_ConnectionPool.setPoolEnabled(false);
    }

    public void disableStreamingMode() {
        this.m_IsStreamingEnabled = false;
    }

    public void enableDefaultConnectionPool() {
        this.m_DefaultPoolingEnabled = true;
        if (this.m_ConnectionPool == null) {
            return;
        }
        if (this.m_IsDefaultPool) {
            return;
        }
        this.m_ConnectionPool.setPoolEnabled(true);
    }

    public void enableStreamingMode() {
        this.m_IsStreamingEnabled = true;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {}
    }

    public DTM getError() {
        return this.m_Error;
    }

    private void init(String driver, String dbURL, Properties prop) throws SQLException {
        String poolName;
        ConnectionPool cpool;
        String passwd;
        Connection con = null;
        String user = prop.getProperty("user");
        if (user == null) {
            user = "";
        }
        if ((passwd = prop.getProperty("password")) == null) {
            passwd = "";
        }
        if ((cpool = this.m_PoolMgr.getPool(poolName = String.valueOf(driver) + dbURL + user + passwd)) == null) {
            DefaultConnectionPool defpool = new DefaultConnectionPool();
            defpool.setDriver(driver);
            defpool.setURL(dbURL);
            defpool.setProtocol(prop);
            if (this.m_DefaultPoolingEnabled) {
                defpool.setPoolEnabled(true);
            }
            this.m_PoolMgr.registerPool(poolName, defpool);
            this.m_ConnectionPool = defpool;
        }
        this.m_IsDefaultPool = true;
        try {
            try {
                con = this.m_ConnectionPool.getConnection();
            }
            catch (SQLException e) {
                if (con != null) {
                    this.m_ConnectionPool.releaseConnectionOnError(con);
                    con = null;
                }
                throw e;
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.m_ConnectionPool.releaseConnection(con);
            throw throwable;
        }
        this.m_ConnectionPool.releaseConnection(con);
    }

    private void initFromElement(Element e) throws SQLException {
        Properties prop = new Properties();
        String driver = "";
        String dbURL = "";
        Node n = e.getFirstChild();
        if (n == null) {
            return;
        }
        do {
            Node n1;
            String s;
            Node n12;
            String nName;
            if ((nName = n.getNodeName()).equalsIgnoreCase("dbdriver")) {
                driver = "";
                n12 = n.getFirstChild();
                if (n12 != null) {
                    driver = n12.getNodeValue();
                }
            }
            if (nName.equalsIgnoreCase("dburl")) {
                dbURL = "";
                n12 = n.getFirstChild();
                if (n12 != null) {
                    dbURL = n12.getNodeValue();
                }
            }
            if (nName.equalsIgnoreCase("password")) {
                s = "";
                n1 = n.getFirstChild();
                if (n1 != null) {
                    s = n1.getNodeValue();
                }
                ((Hashtable)prop).put("password", s);
            }
            if (nName.equalsIgnoreCase("user")) {
                s = "";
                n1 = n.getFirstChild();
                if (n1 != null) {
                    s = n1.getNodeValue();
                }
                ((Hashtable)prop).put("user", s);
            }
            if (!nName.equalsIgnoreCase("protocol")) continue;
            String Name = "";
            NamedNodeMap attrs = n.getAttributes();
            Node n13 = attrs.getNamedItem("name");
            if (n13 == null) continue;
            String s2 = "";
            Name = n13.getNodeValue();
            Node n2 = n.getFirstChild();
            if (n2 != null) {
                s2 = n2.getNodeValue();
            }
            ((Hashtable)prop).put(Name, s2);
        } while ((n = n.getNextSibling()) != null);
        this.init(driver, dbURL, prop);
    }

    public DTM pquery(ExpressionContext exprContext, String queryString) {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                con = this.m_ConnectionPool.getConnection();
                stmt = con.prepareStatement(queryString);
            }
            catch (SQLException e) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (con != null) {
                        this.m_ConnectionPool.releaseConnectionOnError(con);
                    }
                }
                catch (Exception exception) {}
                throw e;
            }
            try {
                Enumeration enumeration = this.m_ParameterList.elements();
                int indx = 1;
                while (enumeration.hasMoreElements()) {
                    QueryParameter qp = (QueryParameter)enumeration.nextElement();
                    this.setParameter(indx, (PreparedStatement)stmt, qp);
                    ++indx;
                }
                rs = stmt.executeQuery();
            }
            catch (SQLException e) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (con != null) {
                        this.m_ConnectionPool.releaseConnectionOnError(con);
                    }
                }
                catch (Exception exception) {}
                throw e;
            }
            DTMManager mgr = ((XPathContext.XPathExpressionContext)exprContext).getDTMManager();
            DTMManagerDefault mgrDefault = (DTMManagerDefault)mgr;
            int dtmIdent = mgrDefault.getFirstFreeDTMID();
            SQLDocument doc = new SQLDocument(mgr, dtmIdent << 22, this.m_ConnectionPool, con, stmt, rs, this.m_IsStreamingEnabled);
            if (doc != null) {
                mgrDefault.addDTM(doc, dtmIdent);
                this.m_OpenSQLDocuments.addElement(doc);
                return doc;
            }
            return null;
        }
        catch (SQLException e) {
            this.buildErrorDocument(exprContext, e);
            return null;
        }
        catch (Exception e) {
            this.buildErrorDocument(exprContext, e);
            return null;
        }
    }

    public DTM pquery(ExpressionContext exprContext, String queryString, String typeInfo) {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            QueryParameter qp;
            StringTokenizer plist = new StringTokenizer(typeInfo);
            int indx = 0;
            while (plist.hasMoreTokens()) {
                String value = plist.nextToken();
                qp = (QueryParameter)this.m_ParameterList.elementAt(indx);
                if (qp != null) {
                    qp.setType(value);
                }
                ++indx;
            }
            try {
                con = this.m_ConnectionPool.getConnection();
                stmt = con.prepareStatement(queryString);
            }
            catch (SQLException e) {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (con != null) {
                        this.m_ConnectionPool.releaseConnectionOnError(con);
                    }
                }
                catch (Exception exception) {}
                throw e;
            }
            try {
                Enumeration enumeration = this.m_ParameterList.elements();
                indx = 1;
                while (enumeration.hasMoreElements()) {
                    qp = (QueryParameter)enumeration.nextElement();
                    this.setParameter(indx, (PreparedStatement)stmt, qp);
                    ++indx;
                }
                rs = stmt.executeQuery();
            }
            catch (SQLException e) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (con != null) {
                        this.m_ConnectionPool.releaseConnectionOnError(con);
                    }
                }
                catch (Exception exception) {}
                throw e;
            }
            DTMManager mgr = ((XPathContext.XPathExpressionContext)exprContext).getDTMManager();
            DTMManagerDefault mgrDefault = (DTMManagerDefault)mgr;
            int dtmIdent = mgrDefault.getFirstFreeDTMID();
            SQLDocument doc = new SQLDocument(mgr, dtmIdent << 22, this.m_ConnectionPool, con, stmt, rs, this.m_IsStreamingEnabled);
            if (doc != null) {
                mgrDefault.addDTM(doc, dtmIdent);
                this.m_OpenSQLDocuments.addElement(doc);
                return doc;
            }
            return null;
        }
        catch (SQLException e) {
            this.buildErrorDocument(exprContext, e);
            return null;
        }
        catch (Exception e) {
            this.buildErrorDocument(exprContext, e);
            return null;
        }
    }

    public DTM query(ExpressionContext exprContext, String queryString) {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        DTMManagerDefault mgrDefault = null;
        SQLDocument doc = null;
        try {
            if (this.m_ConnectionPool == null) {
                return null;
            }
            try {
                con = this.m_ConnectionPool.getConnection();
                stmt = con.createStatement();
                rs = stmt.executeQuery(queryString);
            }
            catch (SQLException e) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (con != null) {
                        this.m_ConnectionPool.releaseConnectionOnError(con);
                    }
                }
                catch (Exception exception) {}
                throw e;
            }
            DTMManager mgr = ((XPathContext.XPathExpressionContext)exprContext).getDTMManager();
            mgrDefault = (DTMManagerDefault)mgr;
            int dtmIdent = mgrDefault.getFirstFreeDTMID();
            doc = new SQLDocument(mgr, dtmIdent << 22, this.m_ConnectionPool, con, stmt, rs, this.m_IsStreamingEnabled);
            if (doc != null) {
                mgrDefault.addDTM(doc, dtmIdent);
                this.m_OpenSQLDocuments.addElement(doc);
                return doc;
            }
            return null;
        }
        catch (SQLException e) {
            if (doc != null && mgrDefault != null) {
                doc.closeOnError();
                mgrDefault.release(doc, true);
            }
            this.buildErrorDocument(exprContext, e);
            return null;
        }
        catch (Exception e) {
            if (doc != null && mgrDefault != null) {
                doc.closeOnError();
                mgrDefault.release(doc, true);
            }
            this.buildErrorDocument(exprContext, e);
            return null;
        }
    }

    public void setParameter(int pos, PreparedStatement stmt, QueryParameter p) throws SQLException {
        String type = p.getType();
        if (type.equalsIgnoreCase("string")) {
            stmt.setString(pos, p.getValue());
        }
        if (type.equalsIgnoreCase("bigdecimal")) {
            stmt.setBigDecimal(pos, new BigDecimal(p.getValue()));
        }
        if (type.equalsIgnoreCase("boolean")) {
            Integer i = new Integer(p.getValue());
            boolean b = i == 0;
            stmt.setBoolean(pos, b);
        }
        if (type.equalsIgnoreCase("bytes")) {
            stmt.setBytes(pos, p.getValue().getBytes());
        }
        if (type.equalsIgnoreCase("date")) {
            stmt.setDate(pos, Date.valueOf(p.getValue()));
        }
        if (type.equalsIgnoreCase("double")) {
            Double d = new Double(p.getValue());
            stmt.setDouble(pos, d);
        }
        if (type.equalsIgnoreCase("float")) {
            Float f = new Float(p.getValue());
            stmt.setFloat(pos, f.floatValue());
        }
        if (type.equalsIgnoreCase("long")) {
            Long l = new Long(p.getValue());
            stmt.setLong(pos, l);
        }
        if (type.equalsIgnoreCase("short")) {
            Short s = new Short(p.getValue());
            stmt.setShort(pos, s);
        }
        if (type.equalsIgnoreCase("time")) {
            stmt.setTime(pos, Time.valueOf(p.getValue()));
        }
        if (type.equalsIgnoreCase("timestamp")) {
            stmt.setTimestamp(pos, Timestamp.valueOf(p.getValue()));
        }
    }
}

