/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.xalan.lib.sql.ConnectionPool;
import org.apache.xalan.lib.sql.PooledConnection;

public class DefaultConnectionPool
implements ConnectionPool {
    private static final boolean DEBUG = false;
    private String m_driver = new String("");
    private String m_url = new String("");
    private int m_PoolMinSize = 1;
    private Properties m_ConnectionProtocol = new Properties();
    private Vector m_pool = new Vector();
    private boolean m_IsActive = false;

    private void addConnection(PooledConnection value) {
        this.m_pool.addElement(value);
    }

    private Connection createConnection() throws SQLException {
        Connection con = null;
        con = DriverManager.getConnection(this.m_url, this.m_ConnectionProtocol);
        return con;
    }

    protected void finalize() throws Throwable {
        int x = 0;
        while (x < this.m_pool.size()) {
            PooledConnection pcon = (PooledConnection)this.m_pool.elementAt(x);
            if (!pcon.inUse()) {
                pcon.close();
            } else {
                try {
                    Thread.sleep(30000L);
                    pcon.close();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            ++x;
        }
        super.finalize();
    }

    public void freeUnused() {
        int x = 0;
        while (x < this.m_pool.size()) {
            PooledConnection pcon = (PooledConnection)this.m_pool.elementAt(x);
            if (!pcon.inUse()) {
                pcon.close();
            }
            ++x;
        }
    }

    public synchronized Connection getConnection() throws IllegalArgumentException, SQLException {
        PooledConnection pcon = null;
        if (this.m_pool.size() < this.m_PoolMinSize) {
            this.initializePool();
        }
        int x = 0;
        while (x < this.m_pool.size()) {
            pcon = (PooledConnection)this.m_pool.elementAt(x);
            if (!pcon.inUse()) {
                pcon.setInUse(true);
                return pcon.getConnection();
            }
            ++x;
        }
        Connection con = this.createConnection();
        pcon = new PooledConnection(con);
        pcon.setInUse(true);
        this.m_pool.addElement(pcon);
        return pcon.getConnection();
    }

    public boolean hasActiveConnections() {
        return this.m_pool.size() > 0;
    }

    public synchronized void initializePool() throws IllegalArgumentException, SQLException {
        if (this.m_driver == null) {
            throw new IllegalArgumentException("No Driver Name Specified!");
        }
        if (this.m_url == null) {
            throw new IllegalArgumentException("No URL Specified!");
        }
        if (this.m_PoolMinSize < 1) {
            throw new IllegalArgumentException("Pool size is less than 1!");
        }
        try {
            Class.forName(this.m_driver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Invalid Driver Name Specified!");
        }
        if (!this.m_IsActive) {
            return;
        }
        do {
            Connection con;
            if ((con = this.createConnection()) == null) continue;
            PooledConnection pcon = new PooledConnection(con);
            this.addConnection(pcon);
        } while (this.m_pool.size() < this.m_PoolMinSize);
    }

    public boolean isEnabled() {
        return this.m_IsActive;
    }

    public synchronized void releaseConnection(Connection con) throws SQLException {
        int x = 0;
        while (x < this.m_pool.size()) {
            PooledConnection pcon = (PooledConnection)this.m_pool.elementAt(x);
            if (pcon.getConnection() == con) {
                if (!this.isEnabled()) {
                    con.close();
                    this.m_pool.removeElementAt(x);
                    break;
                }
                pcon.setInUse(false);
                break;
            }
            ++x;
        }
    }

    public synchronized void releaseConnectionOnError(Connection con) throws SQLException {
        int x = 0;
        while (x < this.m_pool.size()) {
            PooledConnection pcon = (PooledConnection)this.m_pool.elementAt(x);
            if (pcon.getConnection() == con) {
                con.close();
                this.m_pool.removeElementAt(x);
                break;
            }
            ++x;
        }
    }

    public void setDriver(String d) {
        this.m_driver = d;
    }

    public void setMinConnections(int n) {
        this.m_PoolMinSize = n;
    }

    public void setPassword(String p) {
        ((Hashtable)this.m_ConnectionProtocol).put("password", p);
    }

    public void setPoolEnabled(boolean flag) {
    }

    public void setProtocol(Properties p) {
        Enumeration e = ((Hashtable)p).keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ((Hashtable)this.m_ConnectionProtocol).put(key, p.getProperty(key));
        }
    }

    public void setURL(String url) {
        this.m_url = url;
    }

    public void setUser(String u) {
        ((Hashtable)this.m_ConnectionProtocol).put("user", u);
    }

    public boolean testConnection() {
        try {
            Connection conn = this.getConnection();
            if (conn == null) {
                return false;
            }
            this.releaseConnection(conn);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

