/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

class FactoryFinder {
    private static boolean debug = false;
    static /* synthetic */ Class class$javax$xml$transform$FactoryFinder;

    static {
        try {
            debug = System.getProperty("jaxp.debug") != null;
        }
        catch (Exception exception) {}
    }

    FactoryFinder() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private static void debugPrintln(String msg) {
        if (debug) {
            System.err.println("JAXP: " + msg);
        }
    }

    static Object find(String factoryId, String fallbackClassName) throws ConfigurationError {
        ClassLoader classLoader;
        block12: {
            block11: {
                classLoader = FactoryFinder.findClassLoader();
                try {
                    String systemProp = System.getProperty(factoryId);
                    if (systemProp != null) {
                        FactoryFinder.debugPrintln("found system property" + systemProp);
                        return FactoryFinder.newInstance(systemProp, classLoader);
                    }
                }
                catch (SecurityException securityException) {}
                try {
                    String javah = System.getProperty("java.home");
                    String configFile = String.valueOf(javah) + File.separator + "lib" + File.separator + "jaxp.properties";
                    File f = new File(configFile);
                    if (f.exists()) {
                        Properties props = new Properties();
                        props.load(new FileInputStream(f));
                        String factoryClassName = props.getProperty(factoryId);
                        FactoryFinder.debugPrintln("found java.home property " + factoryClassName);
                        return FactoryFinder.newInstance(factoryClassName, classLoader);
                    }
                }
                catch (Exception ex) {
                    if (!debug) break block11;
                    ex.printStackTrace();
                }
            }
            String serviceId = "META-INF/services/" + factoryId;
            try {
                InputStream is = null;
                is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
                if (is != null) {
                    FactoryFinder.debugPrintln("found " + serviceId);
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String factoryClassName = rd.readLine();
                    rd.close();
                    if (factoryClassName != null && !"".equals(factoryClassName)) {
                        FactoryFinder.debugPrintln("loaded from services: " + factoryClassName);
                        return FactoryFinder.newInstance(factoryClassName, classLoader);
                    }
                }
            }
            catch (Exception ex) {
                if (!debug) break block12;
                ex.printStackTrace();
            }
        }
        if (fallbackClassName == null) {
            throw new ConfigurationError("Provider for " + factoryId + " cannot be found", null);
        }
        FactoryFinder.debugPrintln("loaded from fallback value: " + fallbackClassName);
        return FactoryFinder.newInstance(fallbackClassName, classLoader);
    }

    private static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader classLoader;
        try {
            Class<?> clazz = Class.forName(String.valueOf((class$javax$xml$transform$FactoryFinder != null ? class$javax$xml$transform$FactoryFinder : (class$javax$xml$transform$FactoryFinder = FactoryFinder.class$("javax.xml.transform.FactoryFinder"))).getName()) + "$ClassLoaderFinderConcrete");
            ClassLoaderFinder clf = (ClassLoaderFinder)clazz.newInstance();
            classLoader = clf.getContextClassLoader();
        }
        catch (LinkageError linkageError) {
            classLoader = (class$javax$xml$transform$FactoryFinder != null ? class$javax$xml$transform$FactoryFinder : (class$javax$xml$transform$FactoryFinder = FactoryFinder.class$("javax.xml.transform.FactoryFinder"))).getClassLoader();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classLoader = (class$javax$xml$transform$FactoryFinder != null ? class$javax$xml$transform$FactoryFinder : (class$javax$xml$transform$FactoryFinder = FactoryFinder.class$("javax.xml.transform.FactoryFinder"))).getClassLoader();
        }
        catch (Exception x) {
            throw new ConfigurationError(x.toString(), x);
        }
        return classLoader;
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws ConfigurationError {
        try {
            Class<?> spiClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }

    private static abstract class ClassLoaderFinder {
        ClassLoaderFinder() {
        }

        abstract ClassLoader getContextClassLoader();
    }

    static class ClassLoaderFinderConcrete
    extends ClassLoaderFinder {
        ClassLoaderFinderConcrete() {
        }

        ClassLoader getContextClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

