/*
 * Decompiled with CFR 0.152.
 */
package com.mnstarfire.loaders3d;

import com.mnstarfire.loaders3d.Helper3DS;
import com.mnstarfire.loaders3d.Triangle;
import com.mnstarfire.loaders3d.jwTextureLoader;
import com.mnstarfire.utilities.Debug;
import com.sun.j3d.loaders.LoaderBase;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.picking.PickTool;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;

public class Loader3DS
extends LoaderBase {
    private int chunkID;
    private int chunkLength;
    private Hashtable mTable = new Hashtable();
    private Hashtable m2Table = new Hashtable();
    private Boolean twoSided = new Boolean(false);
    private Vector vertices = new Vector();
    private int numofVertices;
    private Vector texVertices = new Vector();
    private BranchGroup sceneBase = new BranchGroup();
    private SceneBase scene = new SceneBase();
    private boolean textureFlag = false;
    private Vector faces = new Vector();
    private int numofFaces;
    private long[] smoothingList;
    private float masterScale = 1.0f;
    private Texture tex;
    private boolean lightTextures = false;
    private Helper3DS helper;
    private boolean usingURL;
    private URL url;
    private String urlBase;
    private String filename;
    private String dirpath;
    private boolean writeLogFile = false;
    private int detailLevel = 0;
    private double creaseAngle = 0.767944871;
    private static final int M3DMAGIC = 19789;
    private static final int M3D_VERSION = 2;
    private static final int MDATA = 15677;
    private static final int MESH_VERSION = 15678;
    private static final int MASTER_SCALE = 256;
    private static final int MAT_ENTRY = 45055;
    private static final int MAT_NAME = 40960;
    private static final int MAT_AMBIENT = 40976;
    private static final int MAT_DIFFUSE = 40992;
    private static final int MAT_SPECULAR = 41008;
    private static final int MAT_SHININESS = 41024;
    private static final int MAT_SHIN2PCT = 41025;
    private static final int MAT_TRANSPARENCY = 41040;
    private static final int MAT_TWO_SIDE = 41089;
    private static final int COLOR_24 = 17;
    private static final int LIN_COLOR_24 = 18;
    private static final int INT_PERCENTAGE = 48;
    private static final int FLOAT_PERCENTAGE = 49;
    private static final int MAT_TEXMAP = 41472;
    private static final int MAT_MAPNAME = 41728;
    private static final int MAT_MAP_TILING = 41809;
    private static final int MAT_MAT_TEXBLUR = 41811;
    private static final int NAMED_OBJECT = 16384;
    private static final int N_TRI_OBJECT = 16640;
    private static final int POINT_ARRAY = 16656;
    private static final int MESH_MATRIX = 16736;
    private static final int FACE_ARRAY = 16672;
    private static final int MSH_MAT_GROUP = 16688;
    private static final int TEX_VERTS = 16704;
    private static final int SMOOTH_GROUP = 16720;
    private static final int KFDATA = 45056;

    public Loader3DS() {
    }

    public Loader3DS(int n) {
    }

    public Scene load(Reader reader) throws FileNotFoundException {
        throw new RuntimeException("Not supported for 3DS");
    }

    public Scene load(String string) throws FileNotFoundException {
        this.filename = string;
        this.usingURL = false;
        this.parseFile();
        this.scene.setSceneGroup(this.sceneBase);
        return this.scene;
    }

    public Scene load(URL uRL) throws FileNotFoundException {
        this.usingURL = true;
        this.url = uRL;
        this.parseURL();
        this.scene.setSceneGroup(this.sceneBase);
        return this.scene;
    }

    public void setURLBase(String string) {
        this.urlBase = string;
    }

    private void parseFile() {
        if (this.writeLogFile) {
            Debug.openLogFile("log3ds.txt");
        }
        Debug.setDebugLevel(this.detailLevel);
        Debug.message("Loader3DS Version 2.00", 1);
        try {
            File file = new File(this.filename);
            if (!file.exists()) {
                System.out.println("File doesn't exist, check name and path: " + this.filename);
                throw new IOException();
            }
            if (this.dirpath == null) {
                this.dirpath = file.getParent();
                if (this.dirpath == null) {
                    this.dirpath = System.getProperty("user.dir");
                }
            }
            this.dirpath = this.dirpath + File.separatorChar;
            Debug.message("Texture path= " + this.dirpath, 1);
            FileInputStream fileInputStream = new FileInputStream(file);
            this.helper = new Helper3DS(fileInputStream);
            this.getStarted();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Loader3DS IOException on file open");
        }
        if (this.writeLogFile) {
            Debug.closeLogFile();
        }
    }

    private void parseURL() {
        if (this.writeLogFile) {
            Debug.openLogFile("log3ds.txt");
        }
        Debug.setDebugLevel(this.detailLevel);
        Debug.message("Loader3DS Version 2.00", 1);
        try {
            URLConnection uRLConnection = this.url.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            this.helper = new Helper3DS(inputStream);
            this.getStarted();
            inputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Loader3DS IOException on URL open");
        }
        if (this.writeLogFile) {
            Debug.closeLogFile();
        }
    }

    void getStarted() {
        this.helper.eof = false;
        while (!this.helper.eof) {
            this.chunkID = this.helper.readShort();
            this.chunkLength = this.helper.readInt();
            switch (this.chunkID) {
                case 19789: {
                    Debug.message(this.displayID(), 1);
                    this.processFile();
                    break;
                }
                default: {
                    Debug.message(this.displayID(), 1);
                    this.helper.skip(this.chunkLength);
                }
            }
        }
    }

    void processFile() {
        long l = this.helper.getPosition() - 6;
        long l2 = l + (long)this.chunkLength;
        while ((long)this.helper.getPosition() < l2 && !this.helper.eof) {
            this.chunkID = this.helper.readShort();
            this.chunkLength = this.helper.readInt();
            switch (this.chunkID) {
                case 2: {
                    Debug.message(this.indent(2) + "Version Chunk " + this.displayID(), 2);
                    this.helper.skip(this.chunkLength);
                    break;
                }
                case 15677: {
                    Debug.message(this.indent(2) + "Mesh Data Chunk " + this.displayID(), 2);
                    this.processMData();
                    break;
                }
                case 45056: {
                    Debug.message(this.indent(2) + "Key Frame Chunk " + this.displayID(), 2);
                    this.helper.skip(this.chunkLength);
                    break;
                }
                default: {
                    Debug.message(this.indent(2) + "Skipping Chunk " + this.displayID(), 2);
                    this.helper.skip(this.chunkLength);
                }
            }
        }
    }

    void processMData() {
        long l = this.helper.getPosition() - 6;
        long l2 = l + (long)this.chunkLength;
        while ((long)this.helper.getPosition() < l2 && !this.helper.eof) {
            this.chunkID = this.helper.readShort();
            this.chunkLength = this.helper.readInt();
            switch (this.chunkID) {
                case 15678: {
                    Debug.message(this.indent(4) + "Mesh Version Chunk " + this.displayID(), 3);
                    this.helper.skip(this.chunkLength);
                    break;
                }
                case 256: {
                    Debug.message(this.indent(4) + "Master Scale Chunk " + this.displayID(), 3);
                    this.masterScale = this.processMasterScale();
                    break;
                }
                case 45055: {
                    Debug.message(this.indent(4) + "Material Entry Chunk " + this.displayID(), 3);
                    this.processMatEntry();
                    break;
                }
                case 16384: {
                    Debug.message(this.indent(4) + "Named Object Chunk " + this.displayID(), 3);
                    this.sceneBase.addChild(this.processNamedObject());
                    break;
                }
                default: {
                    Debug.message(this.indent(4) + "Skipping Chunk " + this.displayID(), 3);
                    this.helper.skip(this.chunkLength);
                }
            }
        }
    }

    float processMasterScale() {
        return this.helper.readFloat();
    }

    void processMatEntry() {
        Appearance appearance = new Appearance();
        Material material = new Material();
        this.twoSided = new Boolean(false);
        this.tex = null;
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes(0, 0.0f);
        String string = null;
        long l = this.helper.getPosition() - 6;
        long l2 = l + (long)this.chunkLength;
        while ((long)this.helper.getPosition() < l2 && !this.helper.eof) {
            this.chunkID = this.helper.readShort();
            this.chunkLength = this.helper.readInt();
            switch (this.chunkID) {
                case 40960: {
                    Debug.message(this.indent(6) + "Mat Name Chunk " + this.displayID(), 3);
                    string = this.processMatName();
                    break;
                }
                case 40976: {
                    Debug.message(this.indent(6) + "Mat Ambient Chunk " + this.displayID(), 3);
                    material.setAmbientColor(this.processAnyColor());
                    break;
                }
                case 40992: {
                    Debug.message(this.indent(6) + "Mat Diffuse Chunk " + this.displayID(), 3);
                    material.setDiffuseColor(this.processAnyColor());
                    break;
                }
                case 41008: {
                    Debug.message(this.indent(6) + "Mat Specular Chunk " + this.displayID(), 3);
                    material.setSpecularColor(this.processAnyColor());
                    break;
                }
                case 41024: {
                    Debug.message(this.indent(6) + "Mat Shininess Chunk " + this.displayID(), 3);
                    material.setShininess(this.processPercentage() * 128.0f);
                    break;
                }
                case 41040: {
                    Debug.message(this.indent(6) + "Mat Transparency Chunk " + this.displayID(), 3);
                    transparencyAttributes.setTransparency(this.processPercentage());
                    break;
                }
                case 41089: {
                    Debug.message(this.indent(6) + "Mat is two sided " + this.displayID(), 3);
                    this.twoSided = new Boolean(true);
                    break;
                }
                case 41472: {
                    Debug.message(this.indent(6) + "Tex Map Chunk " + this.displayID(), 3);
                    this.processTextureMap();
                    break;
                }
                default: {
                    Debug.message(this.indent(6) + "Skipping Chunk " + this.displayID(), 3);
                    this.helper.skip(this.chunkLength);
                }
            }
        }
        if (string != null) {
            Debug.message(this.indent(8) + "Putting " + string + " into hash table", 4);
            if ((double)transparencyAttributes.getTransparency() > 0.01) {
                appearance.setTransparencyAttributes(transparencyAttributes);
            }
            if (this.tex != null) {
                TextureAttributes textureAttributes = new TextureAttributes();
                textureAttributes.setPerspectiveCorrectionMode(0);
                if (this.lightTextures) {
                    textureAttributes.setTextureMode(2);
                }
                appearance.setTextureAttributes(textureAttributes);
                appearance.setTexture(this.tex);
            }
            material.setLightingEnable(true);
            appearance.setMaterial(material);
            this.mTable.put(string, appearance);
            this.m2Table.put(string, this.twoSided);
        }
    }

    String processMatName() {
        String string = this.helper.readString();
        Debug.message(this.indent(8) + "Material Name: " + string, 3);
        return string;
    }

    Color3f processAnyColor() {
        long l = this.helper.getPosition() - 6;
        long l2 = l + (long)this.chunkLength;
        Color3f color3f = new Color3f(1.0f, 1.0f, 1.0f);
        while ((long)this.helper.getPosition() < l2 && !this.helper.eof) {
            this.chunkID = this.helper.readShort();
            this.chunkLength = this.helper.readInt();
            switch (this.chunkID) {
                case 17: {
                    Color color = new Color(this.helper.readByte(), this.helper.readByte(), this.helper.readByte());
                    color3f = new Color3f(color);
                    Debug.message(this.indent(8) + "Color 24 Chunk " + this.displayID() + "Color Value (r,g,b) = " + color.getRed() + "," + color.getGreen() + "," + color.getBlue(), 4);
                    break;
                }
                case 18: {
                    Color color = new Color(this.helper.readByte(), this.helper.readByte(), this.helper.readByte());
                    color3f = new Color3f(color);
                    Debug.message(this.indent(8) + "Lin Color 24 Chunk " + this.displayID() + "Color Value (r,g,b) = " + color.getRed() + "," + color.getGreen() + "," + color.getBlue(), 4);
                    break;
                }
                default: {
                    Debug.message(this.indent(8) + "Skipping Chunk " + this.displayID(), 4);
                    this.helper.skip(this.chunkLength);
                }
            }
        }
        return color3f;
    }

    float processPercentage() {
        float f = 0.0f;
        long l = this.helper.getPosition() - 6;
        long l2 = l + (long)this.chunkLength;
        while ((long)this.helper.getPosition() < l2 && !this.helper.eof) {
            this.chunkID = this.helper.readShort();
            this.chunkLength = this.helper.readInt();
            switch (this.chunkID) {
                case 48: {
                    f = (float)this.helper.readShort() / 100.0f;
                    Debug.message(this.indent(8) + "Integer Percentage Chunk " + this.displayID() + " Value= " + f, 4);
                    break;
                }
                case 49: {
                    f = this.helper.readFloat();
                    Debug.message(this.indent(8) + "Float Percentage Chunk " + this.displayID() + " Value= " + f, 4);
                    break;
                }
                default: {
                    Debug.message(this.indent(8) + "Skipping Chunk " + this.displayID(), 4);
                    this.helper.skip(this.chunkLength);
                }
            }
        }
        return f;
    }

    void processTextureMap() {
        float f = 0.0f;
        long l = this.helper.getPosition() - 6;
        long l2 = l + (long)this.chunkLength;
        while ((long)this.helper.getPosition() < l2 && !this.helper.eof) {
            this.chunkID = this.helper.readShort();
            this.chunkLength = this.helper.readInt();
            switch (this.chunkID) {
                case 48: {
                    f = (float)this.helper.readShort() / 100.0f;
                    Debug.message(this.indent(8) + "Integer Percentage Chunk " + this.displayID() + " Value= " + f, 4);
                    break;
                }
                case 41728: {
                    String string = this.helper.readString();
                    string = string.toLowerCase();
                    Debug.message(this.indent(8) + "Material Mapname Chunk " + this.displayID() + " File= " + string, 4);
                    this.loadTexture(string);
                    break;
                }
                case 41809: {
                    Debug.message(this.indent(8) + "Ignoring Tiling Chunk " + this.displayID(), 4);
                    this.helper.skip(this.chunkLength);
                    break;
                }
                case 41811: {
                    Debug.message(this.indent(8) + "Ignoring Texture Blurring Chunk " + this.displayID(), 4);
                    this.helper.skip(this.chunkLength);
                    break;
                }
                default: {
                    Debug.message(this.indent(8) + "Skipping Chunk " + this.displayID(), 4);
                    this.helper.skip(this.chunkLength);
                }
            }
        }
    }

    void loadTexture(String string) {
        if (this.usingURL) {
            try {
                URL uRL = new URL(this.urlBase + string);
                jwTextureLoader jwTextureLoader2 = new jwTextureLoader(uRL);
                this.tex = jwTextureLoader2.getTexture();
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Malformed URL trying to make texture URL");
            }
        } else {
            jwTextureLoader jwTextureLoader3 = new jwTextureLoader(this.dirpath + string);
            this.tex = jwTextureLoader3.getTexture();
        }
    }

    Node processNamedObject() {
        long l = this.helper.getPosition() - 6;
        long l2 = l + (long)this.chunkLength;
        BranchGroup branchGroup = new BranchGroup();
        while ((long)this.helper.getPosition() < l2 && !this.helper.eof) {
            String string = this.helper.readString();
            Debug.message("      Object Name: " + string, 3);
            TransformGroup transformGroup = new TransformGroup();
            branchGroup.addChild((Node)transformGroup);
            this.scene.addNamedObject(string, (Object)transformGroup);
            this.chunkID = this.helper.readShort();
            this.chunkLength = this.helper.readInt();
            switch (this.chunkID) {
                case 16640: {
                    Debug.message(this.indent(6) + "Tri Object Chunk " + this.displayID(), 4);
                    this.processTriObject((Group)transformGroup);
                    break;
                }
                default: {
                    Debug.message(this.indent(6) + "Skipping Chunk " + this.displayID(), 4);
                    this.helper.skip(this.chunkLength);
                }
            }
        }
        return branchGroup;
    }

    void processTriObject(Group group) {
        this.vertices = new Vector();
        this.numofVertices = 0;
        this.texVertices = new Vector();
        this.faces = new Vector();
        this.textureFlag = false;
        long l = this.helper.getPosition() - 6;
        long l2 = l + (long)this.chunkLength;
        while ((long)this.helper.getPosition() < l2 && !this.helper.eof) {
            this.chunkID = this.helper.readShort();
            this.chunkLength = this.helper.readInt();
            switch (this.chunkID) {
                case 16656: {
                    Debug.message(this.indent(8) + "Point Array Chunk " + this.displayID(), 5);
                    this.processPointArray();
                    break;
                }
                case 16704: {
                    Debug.message(this.indent(8) + "Texture Vertices Array Chunk " + this.displayID(), 5);
                    this.processTexVerts();
                    break;
                }
                case 16736: {
                    Debug.message(this.indent(8) + "Mesh Matrix Chunk " + this.displayID(), 5);
                    this.helper.skip(this.chunkLength);
                    break;
                }
                case 16672: {
                    Debug.message(this.indent(8) + "Face Array Chunk " + this.displayID(), 5);
                    this.processFaceArray(group);
                    break;
                }
                default: {
                    Debug.message(this.indent(8) + "Skipping Chunk " + this.displayID(), 5);
                    this.helper.skip(this.chunkLength);
                }
            }
        }
    }

    void processPointArray() {
        int n;
        this.numofVertices = n = this.helper.readShort();
        Debug.message(this.indent(10) + "Number of Vertices: " + this.numofVertices, 6);
        while (n-- > 0) {
            float f = this.helper.readFloat();
            float f2 = this.helper.readFloat();
            float f3 = this.helper.readFloat();
            this.vertices.addElement(new Point3f(f, f3, -f2));
            Debug.message(this.indent(14) + "Reading Vertex " + f + ", " + f2 + ", " + f3, 9);
        }
    }

    void processTexVerts() {
        this.textureFlag = true;
        int n = this.helper.readShort();
        Debug.message(this.indent(10) + "Number of Texture Vertices: " + n, 6);
        while (n-- > 0) {
            float f = this.helper.readFloat();
            float f2 = this.helper.readFloat();
            this.texVertices.addElement(new Point2f(f, f2));
            Debug.message(this.indent(14) + "Reading Texture Vertex " + f + ", " + f2, 9);
        }
    }

    void processFaceArray(Group group) {
        int n;
        long l = this.helper.getPosition() - 6;
        long l2 = l + (long)this.chunkLength;
        this.numofFaces = this.helper.readShort();
        Debug.message(this.indent(10) + "Number of Faces: " + this.numofFaces, 6);
        int n2 = this.numofFaces;
        while (n2-- > 0) {
            n = this.helper.readShort();
            int n3 = this.helper.readShort();
            int n4 = this.helper.readShort();
            Triangle triangle = new Triangle((Point3f)this.vertices.elementAt(n), (Point3f)this.vertices.elementAt(n3), (Point3f)this.vertices.elementAt(n4));
            if (this.textureFlag) {
                triangle.setTexCoords((Point2f)this.texVertices.elementAt(n), (Point2f)this.texVertices.elementAt(n3), (Point2f)this.texVertices.elementAt(n4));
            }
            this.faces.addElement(triangle);
            this.helper.readShort();
        }
        n = 0;
        block5: while ((long)this.helper.getPosition() < l2 && !this.helper.eof && n == 0) {
            this.chunkID = this.helper.readShort();
            this.chunkLength = this.helper.readInt();
            switch (this.chunkID) {
                case 16688: {
                    Debug.message(this.indent(10) + "Mesh Mat Group Chunk " + this.displayID(), 5);
                    Node node = this.processMshMatGroup();
                    if (node == null) continue block5;
                    group.addChild(node);
                    break;
                }
                case 16720: {
                    Debug.message(this.indent(10) + "Smoothing Group Chunk " + this.displayID(), 5);
                    this.processSmoothGroup();
                    break;
                }
                default: {
                    Debug.message(this.indent(10) + "Skipping Chunk " + this.displayID(), 5);
                    this.helper.skip(this.chunkLength);
                }
            }
        }
    }

    Node processMshMatGroup() {
        String string = this.helper.readString();
        Debug.message(this.indent(12) + "Applying Mat Name: " + string, 5);
        Shape3D shape3D = new Shape3D();
        Appearance appearance = (Appearance)this.mTable.get(string);
        Boolean bl = (Boolean)this.m2Table.get(string);
        boolean bl2 = bl;
        shape3D.setAppearance(appearance);
        GeometryInfo geometryInfo = new GeometryInfo(1);
        Vector<Point3f> vector = new Vector<Point3f>();
        Vector<Point2f> vector2 = new Vector<Point2f>();
        int n = this.helper.readShort();
        Debug.message(this.indent(14) + "Number of triangles = " + n, 5);
        Triangle[] triangleArray = new Triangle[n];
        if (n > 0) {
            Object[] objectArray;
            Triangle triangle;
            int n2 = 0;
            while (n2 < n) {
                triangleArray[n2] = triangle = (Triangle)this.faces.elementAt(this.helper.readShort());
                vector.addElement(triangle.p1);
                vector.addElement(triangle.p2);
                vector.addElement(triangle.p3);
                if (this.textureFlag) {
                    vector2.addElement(triangle.t1);
                    vector2.addElement(triangle.t2);
                    vector2.addElement(triangle.t3);
                }
                ++n2;
            }
            if (bl2) {
                int n3 = n - 1;
                while (n3 > -1) {
                    triangle = triangleArray[n3];
                    vector.addElement(triangle.p3);
                    vector.addElement(triangle.p2);
                    vector.addElement(triangle.p1);
                    if (this.textureFlag) {
                        vector2.addElement(triangle.t3);
                        vector2.addElement(triangle.t2);
                        vector2.addElement(triangle.t1);
                    }
                    --n3;
                }
                n *= 2;
            }
            Object[] objectArray2 = new Point3f[n * 3];
            vector.copyInto(objectArray2);
            geometryInfo.setCoordinates((Point3f[])objectArray2);
            if (this.textureFlag) {
                objectArray = new Point2f[n * 3];
                vector2.copyInto(objectArray);
                geometryInfo.setTextureCoordinates((Point2f[])objectArray);
            }
            objectArray = new NormalGenerator();
            objectArray.setCreaseAngle(this.creaseAngle);
            objectArray.generateNormals(geometryInfo);
            geometryInfo.recomputeIndices();
            shape3D.setGeometry((Geometry)geometryInfo.getGeometryArray());
            PickTool.setCapabilities((Node)shape3D, (int)4098);
        } else {
            shape3D = null;
        }
        return shape3D;
    }

    void processSmoothGroup() {
        int n = 0;
        while (n < this.numofFaces) {
            int n2 = this.helper.readInt();
            Debug.message(this.indent(12) + "SmoothGroup " + n2, 9);
            ++n;
        }
    }

    String indent(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" ");
            ++n2;
        }
        return stringBuffer.toString();
    }

    String displayID() {
        return "ChunkID = " + Integer.toHexString(this.chunkID) + " Length: " + this.chunkLength;
    }

    public void setLogging(boolean bl) {
        this.writeLogFile = bl;
    }

    public void setDetail(int n) {
        this.detailLevel = n;
    }

    public void setTextureLightingOn() {
        this.lightTextures = true;
    }

    public void setTexturePath(String string) {
        this.dirpath = string;
    }

    public void setCreaseAngle(double d) {
        this.creaseAngle = d;
    }
}

