import java.lang.Math;
import java.util.*;
import AMETAS.data.*;
import AMETAS.data.type.*;
import AMETAS.event.*;

/**
 * <p>Agent f&uuml;r &quot;Ametas&quot; (<a href="http://www.ametas.de" target="_blank">www.Ametas.de</a>),
 * der mit anderen Agenten des gleichen Typs (nennen wir diesen Typ "XEventChaserAgent") ber Nachrichten 
 * kommuniziert.</p>
 *
 * <p>Ein XEventChaserAgent, der auf einer Stelle luft, wartet, bis ein Agent des gleichen Typs auf die 
 * Stelle kommt und ihn "verjagt". Mit verjagen ist der Erhalt einer entsprechenden Nachricht und
 * die Migration zu einer anderen als der aktuellen Stelle gemeint. Die mglichen Migrationsstellen
 * sind die folgenden:</p> 
 *
 * <ul>
 * <li>stelle-1.orange.praktikum.cs.uniffm.de</li>
 * <li>stelle-2.orange.praktikum.cs.uniffm.de</li>
 * <li>stelle-3.orange.praktikum.cs.uniffm.de</li>
 * <li>stelle-4.orange.praktikum.cs.uniffm.de</li>
 * </ul>
 *
 * <p>Kommt innerhalb von 30 Sekunden kein Agent des gleichen Typs, erfolgt keine weitere Migration
 * und der Agent beendet sich. Nach insgesamt 10 Migrationen beendet sich ein Agent vom Typ XEventChaserAgent 
 * selbst (um nicht in eine endlose Reise einzutreten).</p>
 *
 * <p>Diese Klasse wurde im Rahmen des Praktikums &quot;Mobile Agenten&quot; im Wintersemester 2000/01
 * am Fachbereich &quot;Verteilte Systeme und Betriebssysteme&quot; des Informatik-Institutes an der 
 * Johann Wolfgang Goethe-Universit&auml;t in Frankfurt erstellt:</p>
 *
 * <p>L&ouml;sung zu Aufgabenblatt 2, Aufgabe 1</p>
 *
 * <p>Autoren (Gruppe &quot;Orange&quot;):</p>
 * <ul>
 * <li>Martin Klossek (<a href="mailto:klossek@informatik.uni-frankfurt.de">klossek@informatik.uni-frankfurt.de</a>)</li>
 * <li>Fabian Wleklinski (<a href="mailto:wleklins@informatik.uni-frankfurt.de">wleklins@informatik.uni-frankfurt.de</a>)</li>
 * </ul>
 *
 * @see <a href="http://www.ametas.de" target="_blank">www.Ametas.de</a>
 */
public class XEventChaserAgent extends AMETAS.event.AMETASNotifiableAgent {

	/**
	 * Die zu wartende Anzahl von Sekunden, bis der Agent ohne Erhalt einer Nachricht beendet.
	 */ 
	final static int sm_nSecondsToWait = 30;

	/**
	 * Der Name der Agenten(klasse), unter der sich Instanzen von XEventChaserAgenten gegenseitig finden knnen.
	 */ 
	final static String sm_sAgentName = "XEventChaserAgent";
	
	/**
	 * "1" wenn der Agent von einem anderen Agenten verjagt wurde,
	 * "2" wenn die Stelle geschlossen wird und
	 * sonst Timeout.
	 */
	public long m_nEscape;


	/**
	 * specification (oder sagen wir mal "Befehl") der Message, zum Verjagen der anderen XEventChaserAgenten
	 */ 
	final static String sm_sAgentMoveRequestCaption = "MOVE_REQUEST";

	/**
	 * Stellennamen-Array mit allen in der Gruppe enthaltenen Stellen, auf die migriert werden kann.
	 */
	final static java.lang.String places[] = {
		"stelle-1.orange.praktikum.cs.uniffm.de.",
		"stelle-2.orange.praktikum.cs.uniffm.de.",
		"stelle-3.orange.praktikum.cs.uniffm.de.",
		"stelle-4.orange.praktikum.cs.uniffm.de."
	};
	
	final static java.lang.String logMigrateText1	= "migriere";
	final static java.lang.String logMigrateText2	= "beende Ausfhrung.";
	final static java.lang.String logHomeText	= "heimatstelle erreicht.";


	/**
	 * Die Anzahl der noch durchzufhrenden Migrationen (1 <= x <= 10)
	 */
	int m_nCurStep = 11;
	
	/**
	 * Der numerische Index der Heimatstelle (1 <= x <= 4), wobei "i" fr die
	 * Stelle "stelle-i.orange.pr..." steht.
	 */
	int m_nHomePlace = 1;
	
	/**
	 * Die Anzahl der Besuche fr jede Stelle
	 */
	int m_visitsCount[] = new int[ 4 ];
	
	/**
	 * Der numerische Index der nchsten, anzuspringenden Stelle (1 <= x <= 4)
	 */
	int m_nextPlaceN = -1;


	/** 
	 * Der Konstruktor der XEventChaserAgent-Klasse: Hier wird der Name des Agenten gesetzt.
 	 * Der Name charakterisiert den Typ des Agenten, wodurch eine Identifikation
	 * anderer Agenten des gleichen Typs mglich wird.
	 */
	public XEventChaserAgent() {
		super(sm_sAgentName, "orange" );
	}
	
	/** 
	 * Die "Run"-Methode des Agenten, die vom Stellenlaufzeitsystem bei jedem Eintreffen 
	 * oder Starten eines Agenten auf dieser Stelle aufgerufen wird.
	 */	
	public void invoke() {
		
		/* Fabian Wleklinski: Den Agenten als Event-Listener der aktuellen
		Stelle registrieren. Wichtig ist hierbei, dass wenn keine explizit
		anderslautende Option angegeben wird, die Nachricht, die ein Event
		auslst, mit diesem Event mitgeschickt wird UND aus dem Postamt
		gelscht wird */
		AMETASMessageMask mask = new AMETASMessageMask( null, new AMETASPlaceUserIDMask(this.getID()), AMETASMessage.UNSPECIFIED );
		Object aMask[] = { mask };
		
		try {
			addEventHandler(new MyEventHandler());
			m_Driver.registerEventListener( AMETASMessageEvent.MESSAGE_RECEIVED_EVENT, 0, aMask );
			m_Driver.registerEventListener( AMETASPlaceEvent.PLACE_SHUTDOWN_EVENT, null );
		} catch ( Exception x ) {
			/* Fabian Wleklinski:
			- "UnauthorizedEventException" sollte nicht auftreten, da
				keine Berechtigungen erforderlich sind
			- "UnknownEventException"
			- "EventParameterException"
			- "DisabledEventException"
			*/
			
			m_Driver.output( "Registrierung gescheitert: " + x.toString() );
		}
		
		/* Fabian Wleklinski: Da wir den textuellen Bezeichner der Heimatstelle
		des Agenten knnen, versuchen wir, diesen Bezeichner einer der vier
		Stellenkonstanten zuzuordnen - so wissen wir, wo wir anfangen mssen.
		Gelingt dies nicht, starten wir in der "virtuellen Stelle" 0. */		
		if (m_bFirstStart) {
			
			/* Martin Klossek: Statusmeldung beim Start des Agenten */
			enhancedOutput ( "gestartet" );
			
			/* Nummer der Heimatstelle in Stellennamen-Array suchen */			
			for (int i=0; i < places.length; i++) {
				if (m_sHomePlace.equalsIgnoreCase( places[ i ] ) ) {
					m_nHomePlace = i + 1;
					m_nextPlaceN = i;
					m_nCurStep--;
					break;
				}
			}
		} else {
			
			/* Martin Klossek: Statusmeldung beim Eintreffen auf neuer Stelle (beim Start
			liegt gewissermaen keine neue Stelle vor ;-) */		
			enhancedOutput ( "an neue Stelle migriert" );
	
		}
	
		/* Methode zum "Suchen" anderer XEventChaserAgenten auf der Stelle aufrufen,
		die "Verjage"-Nachrichten an diese Agenten sendet. */
		// DEBUG: chaseOtherAgents ();	
	
		/* Fabian Wleklinski: Die Statistik updaten */
		if (m_nextPlaceN >= 0) {
			m_visitsCount[ m_nextPlaceN ]++;
		}
		
		/* Martin Klossek: Nur dann etwas unternehmen, wenn noch nicht 10 Migrationen 
		durchgefhrt wurden. */
		if (m_nCurStep > 0) {
	
			/* Methode zum "Suchen" anderer XEventChaserAgenten auf der Stelle aufrufen,
			die "Verjage"-Nachrichten an diese Agenten sendet. */
			chaseOtherAgents ();
			
			/* Fabian Wleklinski: Wir haben die Gewissheit, dass ein Ereignis kommt, wenn
			eine Nachricht fr uns abgelegt wird. Daher knnen wir uns nun in aller Ruhe
			sage und schreibe 30 Sekunden lang schlafen legen... */
			m_nEscape = 0;
			m_Driver.idle( sm_nSecondsToWait * 1000 );
			
			/* Fabian Wleklinski: Entweder ist der Schlaf schon vorbei, oder jemand hat
			uns aufgeweckt. Dise beiden Flle nun unterscheiden: */
			if (m_nEscape == 1) {
					
				/* Statusmeldung ausgeben, wenn "Verjage"-Nachricht eingetroffen */
				// enhancedOutput ("Verjage-Nachricht erhalten [" + (msgArray[i].getBody())[1] + "]" );
				enhancedOutput ("Verjage-Nachricht erhalten." );
	
				/* Anschlieend erfolgt die Migration zu einer zufllig gewhlten Stelle */
				chaseMigrate ();
				
			} else if (m_nEscape == 2) {
				
				/* Fabian Wleklinski: Die Stelle wird geschlossen -> abhauen */
				enhancedOutput( "Stelle schliet bald -> ich werde verschwinden" );

				/* Anschlieend erfolgt die Migration zu einer zufllig gewhlten Stelle */
				chaseMigrate ();
				
			} else {
				
				/* Martin Klossek: Ist nach dem Zeitlimit keine Migration erfolgt, so
				beendet sich der Agent hier selbst und gibt eine entsprechende Meldung aus. */
				enhancedOutput ( "beende nach " + sm_nSecondsToWait + " Sek Idle." );
				
				/* Martin Klossek: Methode zur Ausgabe der Statistikdaten aufrufen */
				statsOutput ();
			}
			
		} else {
			
			/* Martin Klossek: Beenden des Agenten nach 10 Migrationen */			
			enhancedOutput ( "beende nach 10 Migrationen" );
			
			/* Martin Klossek: Methode zur Ausgabe der Statistikdaten aufrufen */
			statsOutput ();
			
		}
		
	}
	
	/**
	 * Martin Klossek: Methode gibt den als Parameter bergebenen String outSt mit der Methode
	 * des Treibers m_Driver.output() aus und fgt die letzten 5 Zeichen der hexadezimalen 
	 * placeUserId vor jeden Ausgabestring an. Damit wird erreicht, dass jede log-Ausgabe 
	 * der jeweiligen Agenteninstanz zugordnet werden kann.
	 */
	private void enhancedOutput (String outSt) {
		
		String ts = getID().toHexString();
		if (ts.length() > 5) {
			m_Driver.output ( ts.substring(ts.length()-5) + ": " + outSt);
		} else {
			m_Driver.output ( ts + ": " + outSt );
		}
		
	}

	/** 
	 * Martin Klossek: Wenn der Agent keine "Verjage"-Nachricht erhalten hat, mu er 
	 * prfen, ob andere XEventChaserAgenten auf der Stelle sind und diese somit verjagen.
	 * Ziel ist, dass nur ein XEventChaserAgent pro Stelle luft. In dieser Methode wird 
	 * geprft, ob andere XEventChaserAgenten auf der Stelle laufen und falls ja wird
	 * ihnen eine "Verjage"-Nachricht gesendet.
	 */
	private void chaseOtherAgents () {
			
		/* Array fr die Nutzlast von Nachrichten */
		Object[] aMessageBody = new Object[2];			
				
		/* Es soll eine Nachricht an alle anderen auf dieser Stelle laufenden XEventChaserAgents
		geschickt werden. Dazu holen wir zunchst die Liste aller laufenden Agenten */
		boolean bNoXEventChaserAgents = true;
		AMETASMediationResult[] aoRunningAgents = m_Driver.request( null );
		
		/* Laufen andere Agenten auf der Stelle (deswegen >1) */
          	if (aoRunningAgents != null && aoRunningAgents.length > 1) {
          		
          		/* Liste der auf dieser Stelle laufenden Agenten durchgehen */
          		for (int i = 0; i < aoRunningAgents.length; i++) {         			
          			
          			AMETASPlaceUserID puidThisRunningAgent = aoRunningAgents[i].getPlaceUserID();
          			
          			/* Wenn es sich bei dem gelieferten Agenten aus der Liste um einen XEventChaserAgent 
          			handelt und dieser auch noch auf der Stelle ist (stillPresent), dann bekommt
          			er eine "Verjage"-Nachricht. Hier wird auch beachtet, dass wir uns nicht
          			selbst eine Nachricht schreiben! */
				if ((puidThisRunningAgent.getName().equals( sm_sAgentName ))
				     && (m_Driver.stillPresent (puidThisRunningAgent))
				     && (!puidThisRunningAgent.equals(getID()))) {					
					
					/* Statusmeldung ausgeben */
					enhancedOutput ( "Verjage-Nachricht an " 
					    + puidThisRunningAgent.toHexString().substring(puidThisRunningAgent.toHexString().length()-5) + "." );
					
					/* "Verjage"-Nachricht zusammensetzen */
					aMessageBody[0] = sm_sAgentMoveRequestCaption;  
					aMessageBody[1] = "chased (from \"" + getID().toHexString().substring(getID().toHexString().length()-5) + "\")";
					
     					/* Abschicken der Nachricht an aoRunningAgents[i].getPlaceUserID() */
     					m_Driver.depositMessage(puidThisRunningAgent, aMessageBody);
     			
     					/* wie man sieht wurden andere XEventChaserAgents auf der Stelle getroffen, 
     					also soll die Meldung "keine XEventChaserAgents angetroffen" nicht 
     					angezeigt werrden */
     					bNoXEventChaserAgents = false;							
				} 
															
			}
			
		} 		

		/* Wenn nur dieser Agent (diese Instanz!) auf der Stelle luft, dann wird 
		auch kein anderer Agent verjagt */		
		if (bNoXEventChaserAgents) {
			
			enhancedOutput ( "keine anderen XEventChaserAgents auf dieser Stelle." );		
			
		}
		
	}
	
	
	/** 
	 * Martin Klossek: In dieser Methode erfolgt die Migration zu einer zuflligen anderen 
	 * Stelle. Die Methode wird von invoke() aus aufgerufen und wurde ausgelagert, um bersicht 
	 * zu gewhrleisten.
	 */
	private void chaseMigrate () {
		
		java.lang.String nextPlace = "";
		java.lang.String logText = logMigrateText1;
	
		/* Martin Klossek: So lange Migrationsversuche starten, bis der Agent zu 
		einer anderen Stelle migrieren konnte */
		boolean migrationSuccess = false;
		// while (! migrationSuccess) {
	
			/* Fabian Wleklinski: Einen Zufallswert zwischen 0 und 3 ermitteln: */
			if (m_nCurStep > 0) {
				m_nextPlaceN = (new Double( Math.random() * 4 )).intValue();
			}			 

			/* Fabian Wleklinski: Die neue Stelle ggf. als "Startstelle" merken */
			/*if ((m_bFirstStart) && (m_nCurStep == 41)) {
				m_nHomePlace = m_nextPlaceN;
			}*/
				
			/* Fabian Wleklinski: Schlauen Spruch ablassen und fortwandern */
			nextPlace = places[ m_nextPlaceN ];
			enhancedOutput ( "migriere (" + (11-m_nCurStep) + "/10) zu Stelle \"" + nextPlace + "\"." );
				
			m_nCurStep--;
			try {
				m_Driver.idle( 500 + (new Double( Math.random() * 500 )).intValue() );
				m_Driver.go( nextPlace, DONT_RELAY );
				
				migrationSuccess = true;
			}
			catch( Exception x ) {
					
				/* Fabian Wleklinski: Whrend der Migration ist ein Fehler aufgetreten.
				Wir werden dies protokollieren, ohne anschlieend gesondert zu verfahren. */					
				enhancedOutput ( "konnte nicht migrieren. versuche erneut." );
				m_nCurStep++;
				
			}
				
		// }		
		
	}


	/** 
	 * Martin Klossek: Methode zum Ausgeben der Statistikdaten (wie oft war die Agenteninstanz
	 * bei den jeweiligen Stellen)
	 */
	private void statsOutput () {
	
		/* Fabian Wleklinski: Statistik ausgeben */
		enhancedOutput ( "war " + m_visitsCount[ 0 ] + " mal bei Stelle \"" + places[ 0 ] + "\"" );
		enhancedOutput ( "war " + m_visitsCount[ 1 ] + " mal bei Stelle \"" + places[ 1 ] + "\"" );
		enhancedOutput ( "war " + m_visitsCount[ 2 ] + " mal bei Stelle \"" + places[ 2 ] + "\"" );
		enhancedOutput ( "war " + m_visitsCount[ 3 ] + " mal bei Stelle \"" + places[ 3 ] + "\"" );
			
	}
	

	/** Ein eigener EventHandler als innere Klasse. */
	public class MyEventHandler extends AMETASEventHandler {
	
		/** Wird von der Methode handleMessageEvent der Elternklasse AMETASEventHandler aufgerufen. */
		//public boolean handleApplicationMessage( String sSpec, Vector vctBodyData, AMETASMessage mes ) {
		public boolean handleApplicationMessage( String sSpec, java.lang.Object[] vctBodyData, AMETASMessage mes ) {

			/*  Wenn die Nachricht eine entsprechende Anfrage eines anderen 
			XEventChaserAgenten ist, dann migrieren */
			if ( (mes.getCategory() == AMETASMessage.APPLICATION)
			      && (mes.getSpecification().equals( sm_sAgentMoveRequestCaption )) ) {
			      	
			      	m_nEscape = 1;
				getDriver().wakeup();
				return true;
				
			}
			
			/* Fabian Wleklinski: Die Nachricht muss nun eben nicht gelscht
			werden, das ist bereits auf dem MessageHandler geschehen. */
			
			/* Die "ausgwertete" Message mu auch noch gelscht werden */
			// m_Driver.deleteMessage (msgArray[i].getID());

			return false;
		}
		
		/** Wird von AMETASNotifiableAgent.notifyListener beim Eintreffen eines 
		Stellenereignisses aufgerufen. */ 
		public boolean handlePlaceEvent( AMETASPlaceEvent evt ) {
			if (evt.getID() == AMETASPlaceEvent.PLACE_SHUTDOWN_EVENT) {
				/* Fabian Wleklinski: Die Stelle wird in Krze beendet,
				eventuelle Aufrumaktionen mssen jetzt durchgefhrt werden */
				
				/* Fabian Wleklinski: Wir wecken einfach mal unseren Treiber auf, und
				der wird dann denken, dass er von einem neueingetroffenen Agenten aus
				dem Schlafgerissen worden ist, und wird migrieren... */
			      	m_nEscape = 2;
				getDriver().wakeup();
				
				return true;
			}
			return false;
		}
	}


}